/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin;

import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.tweaks.MiscTweaks;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import fi.dy.masa.tweakeroo.util.InventoryUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_636;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_636.class})
public abstract class MixinClientPlayerInteractionManager {
    @Shadow
    @Final
    private class_310 field_3712;
    @Shadow
    private int field_3716;

    @Inject(method={"interactItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;syncSelectedSlot()V")}, cancellable=true)
    private void onProcessRightClickFirst(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (CameraUtils.shouldPreventPlayerInputs() || PlacementTweaks.onProcessRightClickPre(player, hand)) {
            cir.setReturnValue((Object)class_1269.field_5811);
            cir.cancel();
        }
    }

    @Inject(method={"method_41929"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;use(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/TypedActionResult;"))}, at={@At(value="RETURN")})
    private void onProcessRightClickPost(class_1268 hand, class_1657 playerEntity, MutableObject<?> mutableObject, int sequence, CallbackInfoReturnable<class_2596<?>> cir) {
        PlacementTweaks.onProcessRightClickPost(playerEntity, hand);
    }

    @Inject(method={"interactEntity(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRightClickMouseOnEntityPre1(class_1657 player, class_1297 target, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (CameraUtils.shouldPreventPlayerInputs() || PlacementTweaks.onProcessRightClickPre(player, hand)) {
            cir.setReturnValue((Object)class_1269.field_5811);
        }
    }

    @Inject(method={"interactEntityAtLocation(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/hit/EntityHitResult;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRightClickMouseOnEntityPre2(class_1657 player, class_1297 target, class_3966 trace, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (CameraUtils.shouldPreventPlayerInputs() || PlacementTweaks.onProcessRightClickPre(player, hand)) {
            cir.setReturnValue((Object)class_1269.field_5811);
        }
    }

    @Inject(method={"attackEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventEntityAttacksInFreeCameraMode(class_1657 player, class_1297 target, CallbackInfo ci) {
        if (CameraUtils.shouldPreventPlayerInputs()) {
            ci.cancel();
        } else if (FeatureToggle.TWEAK_ENTITY_TYPE_ATTACK_RESTRICTION.getBooleanValue() && !MiscTweaks.isEntityAllowedByAttackingRestriction(target.method_5864())) {
            ci.cancel();
        } else if (FeatureToggle.TWEAK_WEAPON_SWITCH.getBooleanValue()) {
            InventoryUtils.trySwitchToWeapon(target);
        }
    }

    @Inject(method={"attackBlock"}, slice={@Slice(from=@At(value="FIELD", ordinal=0, target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;breakingBlock:Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;", ordinal=0)})
    private void onClickBlockPre(class_2338 pos, class_2350 face, CallbackInfoReturnable<Boolean> cir) {
        if (this.field_3712.field_1724 != null && this.field_3712.field_1687 != null) {
            if (FeatureToggle.TWEAK_TOOL_SWITCH.getBooleanValue()) {
                InventoryUtils.trySwitchToEffectiveTool(pos);
            }
            PlacementTweaks.cacheStackInHand(class_1268.field_5808);
        }
    }

    @Inject(method={"attackBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleBreakingRestriction1(class_2338 pos, class_2350 side, CallbackInfoReturnable<Boolean> cir) {
        if (CameraUtils.shouldPreventPlayerInputs() || !PlacementTweaks.isPositionAllowedByBreakingRestriction(pos, side)) {
            cir.setReturnValue((Object)false);
        } else {
            InventoryUtils.trySwapCurrentToolIfNearlyBroken();
        }
    }

    @Inject(method={"updateBlockBreakingProgress"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleBreakingRestriction2(class_2338 pos, class_2350 side, CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_NO_BLOCK_BREAK_CD.getBooleanValue()) {
            this.field_3716 = 0;
        }
        if (CameraUtils.shouldPreventPlayerInputs() || !PlacementTweaks.isPositionAllowedByBreakingRestriction(pos, side)) {
            cir.setReturnValue((Object)true);
        } else {
            InventoryUtils.trySwapCurrentToolIfNearlyBroken();
        }
    }

    @Inject(method={"hasLimitedAttackSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideLimitedAttackSpeed(CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_FAST_LEFT_CLICK.getBooleanValue()) {
            cir.setReturnValue((Object)false);
        }
    }
}

