/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.player;

import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.server.MinecraftServerLib;
import su.plo.lib.api.server.entity.MinecraftServerPlayerEntity;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.server.player.BaseVoicePlayerManager;
import su.plo.voice.server.player.VoiceServerPlayerEntity;

public final class VoiceServerPlayerManager
extends BaseVoicePlayerManager<VoiceServerPlayer> {
    private final PlasmoVoiceServer voiceServer;
    private final MinecraftServerLib minecraftServer;

    @Override
    public Optional<VoiceServerPlayer> getPlayerById(@NotNull UUID playerId, boolean useServerInstance) {
        VoiceServerPlayer voicePlayer = (VoiceServerPlayer)this.playerById.get(playerId);
        if (voicePlayer != null) {
            return Optional.of(voicePlayer);
        }
        if (!useServerInstance) {
            return Optional.empty();
        }
        return this.minecraftServer.getPlayerById(playerId).map(this::wrap);
    }

    @Override
    public Optional<VoiceServerPlayer> getPlayerByName(@NotNull String playerName, boolean useServerInstance) {
        VoiceServerPlayer voicePlayer = (VoiceServerPlayer)this.playerByName.get(playerName);
        if (voicePlayer != null) {
            return Optional.of(voicePlayer);
        }
        if (!useServerInstance) {
            return Optional.empty();
        }
        return this.minecraftServer.getPlayerByName(playerName).map(this::wrap);
    }

    @Override
    @NotNull
    public VoiceServerPlayer wrap(@NotNull Object instance) {
        return this.wrap(this.minecraftServer.getPlayerByInstance(instance));
    }

    @NotNull
    private VoiceServerPlayer wrap(@NotNull MinecraftServerPlayerEntity serverPlayer) {
        return this.playerById.computeIfAbsent(serverPlayer.getUUID(), playerId -> {
            VoiceServerPlayerEntity newPlayer = new VoiceServerPlayerEntity(this.voiceServer, serverPlayer);
            this.playerByName.put(newPlayer.getInstance().getName(), newPlayer);
            return newPlayer;
        });
    }

    public VoiceServerPlayerManager(PlasmoVoiceServer voiceServer, MinecraftServerLib minecraftServer) {
        this.voiceServer = voiceServer;
        this.minecraftServer = minecraftServer;
    }
}

