/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.connection;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.server.event.player.PlayerJoinEvent;
import su.plo.lib.api.server.event.player.PlayerQuitEvent;
import su.plo.lib.api.server.player.MinecraftServerPlayer;
import su.plo.voice.api.server.player.PlayerModLoader;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.connection.PlayerChannelHandler;
import su.plo.voice.server.player.BaseVoicePlayer;
import su.plo.voice.server.util.version.ServerVersionUtil;
import su.plo.voice.util.version.SemanticVersion;

public abstract class BaseServerChannelHandler {
    protected final BaseVoiceServer voiceServer;
    protected final Map<UUID, PlayerChannelHandler> channels = Maps.newHashMap();
    private final Map<UUID, ScheduledFuture<?>> playerCheckFutures = Maps.newConcurrentMap();

    protected BaseServerChannelHandler(@NotNull BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
        PlayerJoinEvent.INSTANCE.registerListener(this::onPlayerJoin);
        PlayerQuitEvent.INSTANCE.registerListener(this::onPlayerQuit);
    }

    public void clear() {
        this.channels.clear();
        PlayerJoinEvent.INSTANCE.unregisterListener(this::onPlayerJoin);
        PlayerQuitEvent.INSTANCE.unregisterListener(this::onPlayerQuit);
    }

    protected void handleRegisterChannels(List<String> channels, VoiceServerPlayer player) {
        if (!this.voiceServer.getUdpServer().isPresent() || this.voiceServer.getConfig() == null) {
            return;
        }
        if (channels.contains("plasmo:voice/v2/installed")) {
            this.voiceServer.getTcpConnectionManager().requestPlayerInfo(player);
            this.cancelPlayerCheckFuture(player.getInstance().getUUID());
            ((BaseVoicePlayer)((Object)player)).setModLoader(channels.contains("fml:handshake") ? PlayerModLoader.FORGE : PlayerModLoader.FABRIC);
        } else if (channels.contains("plasmo:voice")) {
            ((BaseVoicePlayer)((Object)player)).setModLoader(channels.contains("fml:handshake") ? PlayerModLoader.FORGE : PlayerModLoader.FABRIC);
            ServerVersionUtil.suggestSupportedVersion(player, SemanticVersion.parse(this.voiceServer.getVersion()), this.voiceServer.getMinecraftServer().getVersion());
        }
    }

    public void onPlayerJoin(@NotNull MinecraftServerPlayer player) {
        if (!this.voiceServer.getUdpServer().isPresent() || this.voiceServer.getConfig() == null) {
            return;
        }
        if (this.shouldKick(player)) {
            this.cancelPlayerCheckFuture(player.getUUID());
            this.playerCheckFutures.put(player.getUUID(), this.voiceServer.getBackgroundExecutor().schedule(() -> this.voiceServer.getMinecraftServer().executeInMainThread(() -> this.kickModRequired(player)), this.voiceServer.getConfig().voice().clientModRequiredCheckTimeoutMs(), TimeUnit.MILLISECONDS));
        }
    }

    public void onPlayerQuit(@NotNull MinecraftServerPlayer player) {
        this.channels.remove(player.getUUID());
        this.cancelPlayerCheckFuture(player.getUUID());
    }

    private boolean shouldKick(@NotNull MinecraftServerPlayer player) {
        return this.voiceServer.getConfig().voice().clientModRequired() && !player.hasPermission("pv.bypass_mod_requirement");
    }

    private void cancelPlayerCheckFuture(@NotNull UUID playerId) {
        ScheduledFuture<?> future = this.playerCheckFutures.remove(playerId);
        if (future != null) {
            future.cancel(false);
        }
    }

    private void kickModRequired(@NotNull MinecraftServerPlayer player) {
        player.kick(MinecraftTextComponent.translatable("pv.error.mod_missing_kick_message", new Object[0]));
    }
}

