/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.line;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.audio.line.ServerPlayersSet;
import su.plo.voice.api.server.audio.line.ServerSourceLinePlayersSets;
import su.plo.voice.api.server.event.connection.UdpClientDisconnectedEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLinePlayerAddPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLinePlayerRemovePacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLinePlayersListPacket;
import su.plo.voice.server.audio.line.VoiceServerSourceLinePlayersSets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lsu/plo/voice/server/audio/line/VoiceServerSourceLinePlayersSets;", "Lsu/plo/voice/api/server/audio/line/ServerSourceLinePlayersSets;", "sourceLine", "Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;", "(Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;)V", "playersSets", "", "Ljava/util/UUID;", "Lsu/plo/voice/api/server/audio/line/ServerPlayersSet;", "createBroadcastSet", "getPlayersSet", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "onPlayerQuit", "", "event", "Lsu/plo/voice/api/server/event/connection/UdpClientDisconnectedEvent;", "setPlayersSet", "playersSet", "VoiceBroadcastPlayersSet", "VoicePlayersSet", "server-common"})
@SourceDebugExtension(value={"SMAP\nVoiceServerSourceLinePlayersSets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceServerSourceLinePlayersSets.kt\nsu/plo/voice/server/audio/line/VoiceServerSourceLinePlayersSets\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,139:1\n1549#2:140\n1620#2,3:141\n372#3,7:144\n*S KotlinDebug\n*F\n+ 1 VoiceServerSourceLinePlayersSets.kt\nsu/plo/voice/server/audio/line/VoiceServerSourceLinePlayersSets\n*L\n36#1:140\n36#1:141,3\n41#1:144,7\n*E\n"})
public final class VoiceServerSourceLinePlayersSets
implements ServerSourceLinePlayersSets {
    @NotNull
    private final BaseServerSourceLine sourceLine;
    @NotNull
    private final Map<UUID, ServerPlayersSet> playersSets;

    public VoiceServerSourceLinePlayersSets(@NotNull BaseServerSourceLine sourceLine) {
        Intrinsics.checkNotNullParameter(sourceLine, "sourceLine");
        this.sourceLine = sourceLine;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap(...)");
        this.playersSets = concurrentMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPlayersSet(@NotNull VoicePlayer player, @Nullable ServerPlayersSet playersSet) {
        Collection<MinecraftGameProfile> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        if (playersSet == null) {
            this.playersSets.remove(player.getInstance().getUUID());
            player.sendPacket(new SourceLinePlayersListPacket(this.sourceLine.getId(), CollectionsKt.emptyList()));
            return;
        }
        Object object = this.playersSets;
        UUID uUID = player.getInstance().getUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUUID(...)");
        object.put((UUID)uUID, (ServerPlayersSet)playersSet);
        object = playersSet.getPlayers();
        UUID uUID2 = this.sourceLine.getId();
        VoicePlayer voicePlayer = player;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VoicePlayer voicePlayer2 = (VoicePlayer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getInstance().getGameProfile());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        UUID uUID3 = uUID2;
        voicePlayer.sendPacket(new SourceLinePlayersListPacket(uUID3, list));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ServerPlayersSet getPlayersSet(@NotNull VoicePlayer player) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        Map<UUID, ServerPlayersSet> map2 = this.playersSets;
        UUID uUID = player.getInstance().getUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUUID(...)");
        UUID key$iv = uUID;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ServerPlayersSet answer$iv = new VoicePlayersSet(player);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ServerPlayersSet)object;
    }

    @Override
    @NotNull
    public ServerPlayersSet createBroadcastSet() {
        return new VoiceBroadcastPlayersSet();
    }

    @EventSubscribe
    public final void onPlayerQuit(@NotNull UdpClientDisconnectedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.playersSets.remove(event.getConnection().getPlayer().getInstance().getUUID());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0014\u0010\t\u001a\u00020\u00072\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\b\u0010\f\u001a\u00020\u0007H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lsu/plo/voice/server/audio/line/VoiceServerSourceLinePlayersSets$VoiceBroadcastPlayersSet;", "Lsu/plo/voice/api/server/audio/line/ServerPlayersSet;", "(Lsu/plo/voice/server/audio/line/VoiceServerSourceLinePlayersSets;)V", "players", "", "Lsu/plo/voice/api/server/player/VoicePlayer;", "addPlayer", "", "player", "broadcast", "packet", "Lsu/plo/voice/proto/packets/Packet;", "clearPlayers", "getPlayers", "", "removePlayer", "", "playerId", "Ljava/util/UUID;", "server-common"})
    public final class VoiceBroadcastPlayersSet
    implements ServerPlayersSet {
        @NotNull
        private final Set<VoicePlayer> players;

        public VoiceBroadcastPlayersSet() {
            CopyOnWriteArraySet copyOnWriteArraySet = Sets.newCopyOnWriteArraySet();
            Intrinsics.checkNotNullExpressionValue(copyOnWriteArraySet, "newCopyOnWriteArraySet(...)");
            this.players = copyOnWriteArraySet;
        }

        @Override
        public void addPlayer(@NotNull VoicePlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            if (this.players.contains(player)) {
                return;
            }
            this.broadcast(new SourceLinePlayerAddPacket(VoiceServerSourceLinePlayersSets.this.sourceLine.getId(), player.getInstance().getGameProfile()));
            this.players.add(player);
            player.sendPacket(new SourceLinePlayersListPacket(VoiceServerSourceLinePlayersSets.this.sourceLine.getId(), this.players.stream().map(arg_0 -> VoiceBroadcastPlayersSet.addPlayer$lambda$0(addPlayer.1.INSTANCE, arg_0)).collect(Collectors.toList())));
        }

        @Override
        public boolean removePlayer(@NotNull UUID playerId) {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Boolean bl = this.players.stream().filter(arg_0 -> VoiceBroadcastPlayersSet.removePlayer$lambda$1(new Function1<VoicePlayer, Boolean>(playerId){
                final /* synthetic */ UUID $playerId;
                {
                    this.$playerId = $playerId;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull VoicePlayer player) {
                    Intrinsics.checkNotNullParameter(player, "player");
                    return Intrinsics.areEqual(player.getInstance().getUUID(), this.$playerId);
                }
            }, arg_0)).findFirst().map(arg_0 -> VoiceBroadcastPlayersSet.removePlayer$lambda$2(new Function1<VoicePlayer, Boolean>(this, VoiceServerSourceLinePlayersSets.this, playerId){
                final /* synthetic */ VoiceBroadcastPlayersSet this$0;
                final /* synthetic */ VoiceServerSourceLinePlayersSets this$1;
                final /* synthetic */ UUID $playerId;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$playerId = $playerId;
                    super(1);
                }

                public final Boolean invoke(VoicePlayer player) {
                    VoiceBroadcastPlayersSet.access$broadcast(this.this$0, new SourceLinePlayerRemovePacket(VoiceServerSourceLinePlayersSets.access$getSourceLine$p(this.this$1).getId(), this.$playerId));
                    VoiceBroadcastPlayersSet.access$getPlayers$p(this.this$0).remove(player);
                    return true;
                }
            }, arg_0)).orElse(false);
            Intrinsics.checkNotNullExpressionValue(bl, "orElse(...)");
            return bl;
        }

        @Override
        public void clearPlayers() {
            this.players.forEach(arg_0 -> VoiceBroadcastPlayersSet.clearPlayers$lambda$3(VoiceServerSourceLinePlayersSets.this, arg_0));
            this.players.clear();
        }

        @Override
        @NotNull
        public Collection<VoicePlayer> getPlayers() {
            return this.players;
        }

        private final void broadcast(Packet<?> packet) {
            this.players.forEach(arg_0 -> VoiceBroadcastPlayersSet.broadcast$lambda$4(packet, arg_0));
        }

        private static final MinecraftGameProfile addPlayer$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (MinecraftGameProfile)$tmp0.invoke(p0);
        }

        private static final boolean removePlayer$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Boolean removePlayer$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void clearPlayers$lambda$3(VoiceServerSourceLinePlayersSets this$0, VoicePlayer player) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(player, "player");
            player.sendPacket(new SourceLinePlayersListPacket(this$0.sourceLine.getId(), CollectionsKt.emptyList()));
        }

        private static final void broadcast$lambda$4(Packet $packet, VoicePlayer player) {
            Intrinsics.checkNotNullParameter($packet, "$packet");
            Intrinsics.checkNotNullParameter(player, "player");
            player.sendPacket($packet);
        }

        public static final /* synthetic */ void access$broadcast(VoiceBroadcastPlayersSet $this, Packet packet) {
            $this.broadcast(packet);
        }

        public static final /* synthetic */ Set access$getPlayers$p(VoiceBroadcastPlayersSet $this) {
            return $this.players;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lsu/plo/voice/server/audio/line/VoiceServerSourceLinePlayersSets$VoicePlayersSet;", "Lsu/plo/voice/api/server/audio/line/ServerPlayersSet;", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "(Lsu/plo/voice/server/audio/line/VoiceServerSourceLinePlayersSets;Lsu/plo/voice/api/server/player/VoicePlayer;)V", "players", "", "addPlayer", "", "clearPlayers", "getPlayers", "", "removePlayer", "", "playerId", "Ljava/util/UUID;", "server-common"})
    public final class VoicePlayersSet
    implements ServerPlayersSet {
        @NotNull
        private final VoicePlayer player;
        @NotNull
        private final Set<VoicePlayer> players;

        public VoicePlayersSet(VoicePlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            this.player = player;
            CopyOnWriteArraySet copyOnWriteArraySet = Sets.newCopyOnWriteArraySet();
            Intrinsics.checkNotNullExpressionValue(copyOnWriteArraySet, "newCopyOnWriteArraySet(...)");
            this.players = copyOnWriteArraySet;
        }

        @Override
        public void addPlayer(@NotNull VoicePlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            this.players.add(player);
            player.sendPacket(new SourceLinePlayerAddPacket(VoiceServerSourceLinePlayersSets.this.sourceLine.getId(), player.getInstance().getGameProfile()));
        }

        @Override
        public boolean removePlayer(@NotNull UUID playerId) {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Boolean bl = this.players.stream().filter(arg_0 -> VoicePlayersSet.removePlayer$lambda$0(new Function1<VoicePlayer, Boolean>(playerId){
                final /* synthetic */ UUID $playerId;
                {
                    this.$playerId = $playerId;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull VoicePlayer player) {
                    Intrinsics.checkNotNullParameter(player, "player");
                    return Intrinsics.areEqual(player.getInstance().getUUID(), this.$playerId);
                }
            }, arg_0)).findFirst().map(arg_0 -> VoicePlayersSet.removePlayer$lambda$1(new Function1<VoicePlayer, Boolean>(VoiceServerSourceLinePlayersSets.this, playerId, this){
                final /* synthetic */ VoiceServerSourceLinePlayersSets this$0;
                final /* synthetic */ UUID $playerId;
                final /* synthetic */ VoicePlayersSet this$1;
                {
                    this.this$0 = $receiver;
                    this.$playerId = $playerId;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final Boolean invoke(VoicePlayer player) {
                    player.sendPacket(new SourceLinePlayerRemovePacket(VoiceServerSourceLinePlayersSets.access$getSourceLine$p(this.this$0).getId(), this.$playerId));
                    VoicePlayersSet.access$getPlayers$p(this.this$1).remove(player);
                    return true;
                }
            }, arg_0)).orElse(false);
            Intrinsics.checkNotNullExpressionValue(bl, "orElse(...)");
            return bl;
        }

        @Override
        public void clearPlayers() {
            this.player.sendPacket(new SourceLinePlayersListPacket(VoiceServerSourceLinePlayersSets.this.sourceLine.getId()));
            this.players.clear();
        }

        @Override
        @NotNull
        public Collection<VoicePlayer> getPlayers() {
            return this.players;
        }

        private static final boolean removePlayer$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Boolean removePlayer$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ Set access$getPlayers$p(VoicePlayersSet $this) {
            return $this.players;
        }
    }
}

