/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.audio.capture;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.packets.PacketSerializable;
import su.plo.voice.proto.packets.PacketUtil;

public class VoiceActivation
implements Activation,
PacketSerializable {
    public static final String PROXIMITY_NAME = "proximity";
    public static final UUID PROXIMITY_ID = VoiceActivation.generateId("proximity");
    protected UUID id;
    protected String name;
    protected String translation;
    protected String icon;
    protected List<Integer> distances = ImmutableList.of();
    protected int defaultDistance;
    protected boolean proximity;
    protected boolean transitive;
    protected boolean stereoSupported;
    @Nullable
    protected CodecInfo encoderInfo;
    protected int weight;

    public static UUID generateId(@NotNull String name) {
        return UUID.nameUUIDFromBytes((name + "_activation").getBytes(Charsets.UTF_8));
    }

    public VoiceActivation(@NotNull String name, @NotNull String translation, @NotNull String icon, List<Integer> distances, int defaultDistance, boolean proximity, boolean stereoSupported, boolean transitive, @Nullable CodecInfo encoderInfo, int weight) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.translation = translation;
        this.icon = (String)Preconditions.checkNotNull((Object)icon);
        this.id = VoiceActivation.generateId(name);
        this.distances = (List)Preconditions.checkNotNull(distances);
        this.defaultDistance = defaultDistance;
        this.proximity = proximity;
        this.stereoSupported = stereoSupported;
        this.transitive = transitive;
        this.encoderInfo = encoderInfo;
        this.weight = weight;
    }

    @Override
    public List<Integer> getDistances() {
        return this.distances;
    }

    @Override
    public int getMinDistance() {
        if (this.distances.size() == 0) {
            return -1;
        }
        return this.distances.get(0);
    }

    @Override
    public int getMaxDistance() {
        if (this.distances.size() == 0) {
            return -1;
        }
        return this.distances.get(this.distances.size() - 1);
    }

    @Override
    public Optional<CodecInfo> getEncoderInfo() {
        return Optional.ofNullable(this.encoderInfo);
    }

    @Override
    public void deserialize(ByteArrayDataInput in) {
        this.name = in.readUTF();
        this.translation = in.readUTF();
        this.icon = in.readUTF();
        this.id = VoiceActivation.generateId(this.name);
        this.distances = PacketUtil.readIntList(in);
        this.defaultDistance = in.readInt();
        this.proximity = in.readBoolean();
        this.transitive = in.readBoolean();
        this.stereoSupported = in.readBoolean();
        if (in.readBoolean()) {
            this.encoderInfo = new CodecInfo();
            this.encoderInfo.deserialize(in);
        }
        this.weight = in.readInt();
    }

    @Override
    public void serialize(ByteArrayDataOutput out) {
        out.writeUTF(this.name);
        out.writeUTF(this.translation);
        out.writeUTF(this.icon);
        PacketUtil.writeIntList(out, this.distances);
        out.writeInt(this.defaultDistance);
        out.writeBoolean(this.proximity);
        out.writeBoolean(this.transitive);
        out.writeBoolean(this.stereoSupported);
        out.writeBoolean(this.encoderInfo != null);
        if (this.encoderInfo != null) {
            this.encoderInfo.serialize(out);
        }
        out.writeInt(this.weight);
    }

    public VoiceActivation() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoiceActivation)) {
            return false;
        }
        VoiceActivation other = (VoiceActivation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VoiceActivation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        UUID $id = this.getId();
        result2 = result2 * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result2;
    }

    public String toString() {
        return "VoiceActivation(id=" + this.getId() + ", name=" + this.getName() + ", translation=" + this.getTranslation() + ", icon=" + this.getIcon() + ", distances=" + this.getDistances() + ", defaultDistance=" + this.getDefaultDistance() + ", proximity=" + this.isProximity() + ", transitive=" + this.isTransitive() + ", stereoSupported=" + this.isStereoSupported() + ", encoderInfo=" + this.getEncoderInfo() + ", weight=" + this.getWeight() + ")";
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTranslation() {
        return this.translation;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public int getDefaultDistance() {
        return this.defaultDistance;
    }

    @Override
    public boolean isProximity() {
        return this.proximity;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isStereoSupported() {
        return this.stereoSupported;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }
}

