/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.socket;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.event.connection.UdpClientPacketReceivedEvent;
import su.plo.voice.api.client.event.socket.UdpClientClosedEvent;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.audio.source.VoiceClientSelfSourceInfo;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.socket.NettyUdpClient;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.bothbound.CustomPacket;
import su.plo.voice.proto.packets.udp.bothbound.PingPacket;
import su.plo.voice.proto.packets.udp.clientbound.ClientPacketUdpHandler;
import su.plo.voice.proto.packets.udp.clientbound.SelfAudioInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.socket.NettyPacketUdp;

public final class NettyUdpClientHandler
extends SimpleChannelInboundHandler<NettyPacketUdp>
implements ClientPacketUdpHandler {
    private static final long MAX_KEEP_ALIVE_TIMEOUT = 30000L;
    private static final long MAX_SOFT_KEEP_ALIVE_TIMEOUT = 7000L;
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final NettyUdpClient client;
    private final ScheduledFuture<?> ticker;
    private long keepAlive = System.currentTimeMillis();

    public NettyUdpClientHandler(@NotNull BaseVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull NettyUdpClient client) {
        this.voiceClient = (PlasmoVoiceClient)Preconditions.checkNotNull((Object)voiceClient, (Object)"voiceClient");
        this.config = (VoiceClientConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.client = (NettyUdpClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.ticker = voiceClient.getBackgroundExecutor().scheduleAtFixedRate(this::tick, 0L, 1L, TimeUnit.SECONDS);
    }

    public void close() {
        if (this.ticker.isDone()) {
            return;
        }
        this.ticker.cancel(false);
    }

    protected void channelRead0(ChannelHandlerContext ctx, NettyPacketUdp packetUdp) throws Exception {
        Packet<NettyUdpClientHandler> packet = packetUdp.getPacketUdp().getPacket();
        UdpClientPacketReceivedEvent event = new UdpClientPacketReceivedEvent(this.client, packet);
        this.voiceClient.getEventBus().call(event);
        if (event.isCancelled()) {
            return;
        }
        packet.handle(this);
    }

    @Override
    public void handle(@NotNull PingPacket packet) {
        this.client.setTimedOut(false);
        this.keepAlive = System.currentTimeMillis();
        this.client.sendPacket(new PingPacket());
    }

    @Override
    public void handle(@NotNull CustomPacket packet) {
    }

    @Override
    public void handle(@NotNull SourceAudioPacket packet) {
        if (((Boolean)this.config.getVoice().getDisabled().value()).booleanValue()) {
            return;
        }
        this.voiceClient.getSourceManager().getSourceById(packet.getSourceId()).ifPresent(source -> {
            if (((SourceInfo)source.getSourceInfo()).getState() != packet.getSourceState()) {
                this.voiceClient.getSourceManager().sendSourceInfoRequest(packet.getSourceId(), true);
            }
            source.process(packet);
        });
    }

    @Override
    public void handle(@NotNull SelfAudioInfoPacket packet) {
        if (((Boolean)this.config.getVoice().getDisabled().value()).booleanValue()) {
            return;
        }
        this.voiceClient.getSourceManager().getSelfSourceInfo(packet.getSourceId()).ifPresent(sourceInfo -> {
            VoiceClientSelfSourceInfo selfSourceInfo = (VoiceClientSelfSourceInfo)sourceInfo;
            selfSourceInfo.setSequenceNumber(packet.getSequenceNumber());
            selfSourceInfo.setDistance(packet.getDistance());
        });
    }

    private void tick() {
        long diff;
        if (!this.client.getRemoteAddress().isPresent()) {
            return;
        }
        if (!this.client.isConnected()) {
            this.client.sendPacket(new PingPacket());
        }
        if ((diff = System.currentTimeMillis() - this.keepAlive) > 30000L) {
            BaseVoice.LOGGER.warn("UDP timed out. Disconnecting...");
            this.client.close(UdpClientClosedEvent.Reason.TIMED_OUT);
        } else if (diff > 7000L) {
            this.client.setTimedOut(true);
        }
    }
}

