/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;
import su.plo.voice.universal.UResolution;

public final class DropDownWidget
extends GuiAbstractWidget {
    private static final int ELEMENT_HEIGHT = 16;
    private final VoiceSettingsScreen parent;
    private final List<MinecraftTextComponent> elements;
    private final boolean tooltip;
    private final Consumer<Integer> onSelect;
    private boolean open;

    public DropDownWidget(@NotNull VoiceSettingsScreen parent, int x, int y, int width, int height, @NotNull MinecraftTextComponent message, @NotNull List<MinecraftTextComponent> elements, boolean tooltip, @NotNull Consumer<Integer> onSelect) {
        super(x, y, width, height, message);
        this.parent = parent;
        this.elements = elements;
        this.onSelect = onSelect;
        this.tooltip = tooltip;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            this.open = !this.open;
            return true;
        }
        if (!this.open) {
            return false;
        }
        this.open = false;
        if (!this.elementClicked(mouseX, mouseY, button)) {
            this.playDownSound();
        }
        return true;
    }

    @Override
    public void renderButton(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        this.renderBackground(stack, mouseX, mouseY);
        this.renderArrow(stack);
        this.renderText(stack);
        if (!this.open) {
            return;
        }
        this.renderElements(stack, mouseX, mouseY);
    }

    @Override
    protected void renderBackground(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        UGraphics.enableBlend();
        RenderUtil.defaultBlendFunc();
        UGraphics.enableDepth();
        RenderUtil.fill(stack, this.x, this.y, this.x + this.width, this.y + this.height, -6250336);
        RenderUtil.fill(stack, this.x + 1, this.y + 1, this.x + this.width - 1, this.y + this.height - 1, -16777216);
    }

    private void renderElements(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        boolean renderToTop = this.renderToTop();
        int elementY = renderToTop ? this.y - this.elements.size() * 17 : this.y + this.height;
        for (MinecraftTextComponent element : this.elements) {
            UGraphics.enableDepth();
            stack.push();
            stack.translate(0.0, 0.0, 10.0);
            if (renderToTop) {
                RenderUtil.fill(stack, this.x, elementY - 1, this.x + this.width, elementY + 16, -12171706);
            } else {
                RenderUtil.fill(stack, this.x, elementY, this.x + this.width, elementY + 16 + 1, -12171706);
            }
            RenderUtil.fill(stack, this.x + 1, elementY, this.x + this.width - 1, elementY + 16, -16777216);
            if (mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= elementY && mouseY <= elementY + 16) {
                if (this.tooltip && RenderUtil.getTextWidth(element) > this.width - 10) {
                    this.parent.setTooltip(element);
                }
                RenderUtil.fill(stack, this.x + 1, elementY, this.x + this.width - 1, elementY + 16, -13487566);
            }
            RenderUtil.drawOrderedString(stack, element, this.width - 10, this.x + 5, elementY + 8 - UGraphics.getFontHeight() / 2, 0xE0E0E0);
            stack.pop();
            UGraphics.disableDepth();
            elementY += 17;
        }
    }

    private void renderText(@NotNull UMatrixStack stack) {
        RenderUtil.drawOrderedString(stack, this.getText(), this.active ? this.width - 23 : this.width - 5, this.x + 5, this.y + this.height / 2 - UGraphics.getFontHeight() / 2, this.active ? 0xE0E0E0 : 0x707070);
    }

    private void renderArrow(@NotNull UMatrixStack stack) {
        if (!this.active) {
            return;
        }
        UGraphics.enableBlend();
        RenderUtil.defaultBlendFunc();
        UGraphics.enableDepth();
        if (this.open) {
            for (int i = 0; i < 5; ++i) {
                RenderUtil.fill(stack, this.x + this.width - (9 + i), this.y + (this.height - 5) / 2 + i, this.x + this.width - (8 - i), this.y + (this.height - 5) / 2 + 2 + i, -6250336);
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                RenderUtil.fill(stack, this.x + this.width - (13 - i), this.y + (this.height - 5) / 2 + (i > 0 ? 1 + i : 0), this.x + this.width - (4 + i), this.y + (this.height - 5) / 2 + 2 + i, -6250336);
            }
        }
    }

    private boolean renderToTop() {
        return this.y + this.height + 1 + this.elements.size() * 17 > UResolution.getScaledHeight() && this.parent.getNavigation().getHeight() + this.height + 1 + this.elements.size() * 17 < UResolution.getScaledHeight();
    }

    private boolean elementClicked(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            if (this.renderToTop()) {
                if (mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)(this.y + 1 - this.elements.size() * 17) && mouseY <= (double)(this.y + 1)) {
                    int i = (int)Math.floor((mouseY - (double)(this.y + 1 - this.elements.size() * 17)) / 17.0);
                    this.playDownSound();
                    this.text = this.elements.get(i);
                    if (this.onSelect != null) {
                        this.onSelect.accept(i);
                    }
                    return true;
                }
            } else if (mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)(this.y + 1 + this.height) && mouseY <= (double)(this.y + 1 + this.height + this.elements.size() * 17)) {
                int i = (int)Math.floor((mouseY - (double)(this.y + this.height + 1)) / 17.0);
                this.playDownSound();
                this.text = this.elements.get(i);
                if (this.onSelect != null) {
                    this.onSelect.accept(i);
                }
                return true;
            }
        }
        return false;
    }
}

