/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.chat.MinecraftTextStyle;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.components.IconButton;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetListener;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.AboutTabWidget;
import su.plo.voice.client.gui.settings.tab.AbstractHotKeysTabWidget;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.widget.TabButton;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UKeyboard;
import su.plo.voice.universal.UMatrixStack;
import su.plo.voice.universal.UMinecraft;

public final class VoiceSettingsNavigation
implements GuiWidgetListener {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceSettingsScreen parent;
    private final VoiceClientConfig config;
    private final List<Button> disableMicrophoneButtons = Lists.newArrayList();
    private final List<Button> disableVoiceButtons = Lists.newArrayList();
    private final List<TabWidget> tabWidgets = Lists.newArrayList();
    private final List<Button> tabButtons = Lists.newArrayList();
    @Nullable
    private AboutTabWidget aboutTabWidget;
    private int active;

    public VoiceSettingsNavigation(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceSettingsScreen parent, @NotNull VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.parent = parent;
        this.config = config;
    }

    @Override
    public boolean keyPressed(int keyCode, @Nullable UKeyboard.Modifiers modifiers) {
        if (keyCode == 256 || keyCode == 258) {
            Optional<TabWidget> tab = this.getActiveTab();
            if (!tab.isPresent()) {
                return false;
            }
            if (!(tab.get() instanceof AbstractHotKeysTabWidget)) {
                return false;
            }
            return tab.get().keyPressed(keyCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.getActiveTab().ifPresent(tab -> {
            if (!(tab instanceof AbstractHotKeysTabWidget)) {
                return;
            }
            tab.mouseReleased(mouseX, mouseY, button);
        });
        return false;
    }

    public void tick() {
        this.getActiveTab().ifPresent(TabWidget::tick);
    }

    public void init() {
        this.aboutTabWidget = new AboutTabWidget(this.parent, this.voiceClient, this.config);
        this.disableMicrophoneButtons.clear();
        this.disableVoiceButtons.clear();
        IconButton disableMicrophoneHide = new IconButton(this.parent.getWidth() - 52, 8, 20, 20, button -> {
            this.disableMicrophoneButtons.get(0).setVisible(false);
            this.disableMicrophoneButtons.get(1).setVisible(true);
            this.config.getVoice().getMicrophoneDisabled().set(true);
        }, (button, render, mouseX, mouseY) -> this.parent.setTooltip(MinecraftTextComponent.translatable("gui.plasmovoice.toggle.microphone", MinecraftTextComponent.translatable("gui.plasmovoice.toggle.currently", MinecraftTextComponent.translatable("gui.plasmovoice.toggle.enabled", new Object[0]).withStyle(MinecraftTextStyle.GREEN)).withStyle(MinecraftTextStyle.GRAY))), class_2960.method_12829((String)"plasmovoice:textures/icons/microphone_menu.png"), true);
        IconButton disableMicrophoneShow = new IconButton(this.parent.getWidth() - 52, 8, 20, 20, button -> {
            this.disableMicrophoneButtons.get(0).setVisible(true);
            this.disableMicrophoneButtons.get(1).setVisible(false);
            this.config.getVoice().getMicrophoneDisabled().set(false);
            if (((Boolean)this.config.getVoice().getDisabled().value()).booleanValue()) {
                this.disableVoiceButtons.get(0).setVisible(true);
                this.disableVoiceButtons.get(1).setVisible(false);
                this.config.getVoice().getDisabled().set(false);
            }
        }, (button, render, mouseX, mouseY) -> this.parent.setTooltip(MinecraftTextComponent.translatable("gui.plasmovoice.toggle.microphone", MinecraftTextComponent.translatable("gui.plasmovoice.toggle.currently", MinecraftTextComponent.translatable("gui.plasmovoice.toggle.disabled", new Object[0]).withStyle(MinecraftTextStyle.RED)).withStyle(MinecraftTextStyle.GRAY))), class_2960.method_12829((String)"plasmovoice:textures/icons/microphone_menu_disabled.png"), true);
        disableMicrophoneHide.setVisible((Boolean)this.config.getVoice().getMicrophoneDisabled().value() == false && (Boolean)this.config.getVoice().getDisabled().value() == false);
        disableMicrophoneShow.setVisible((Boolean)this.config.getVoice().getMicrophoneDisabled().value() != false || (Boolean)this.config.getVoice().getDisabled().value() != false);
        IconButton disableVoiceHide = new IconButton(this.parent.getWidth() - 28, 8, 20, 20, button -> {
            this.disableVoiceButtons.get(0).setVisible(false);
            this.disableVoiceButtons.get(1).setVisible(true);
            this.config.getVoice().getDisabled().set((Boolean)this.config.getVoice().getDisabled().value() == false);
            this.voiceClient.getSourceManager().clear();
            if (!((Boolean)this.config.getVoice().getMicrophoneDisabled().value()).booleanValue()) {
                this.disableMicrophoneButtons.get(0).setVisible(false);
                this.disableMicrophoneButtons.get(1).setVisible(true);
            }
        }, (button, render, mouseX, mouseY) -> this.parent.setTooltip(MinecraftTextComponent.translatable("gui.plasmovoice.toggle.voice", MinecraftTextComponent.translatable("gui.plasmovoice.toggle.currently", MinecraftTextComponent.translatable("gui.plasmovoice.toggle.enabled", new Object[0]).withStyle(MinecraftTextStyle.GREEN)).withStyle(MinecraftTextStyle.GRAY))), class_2960.method_12829((String)"plasmovoice:textures/icons/speaker_menu.png"), true);
        IconButton disableVoiceShow = new IconButton(this.parent.getWidth() - 28, 8, 20, 20, button -> {
            this.disableVoiceButtons.get(0).setVisible(true);
            this.disableVoiceButtons.get(1).setVisible(false);
            this.config.getVoice().getDisabled().set((Boolean)this.config.getVoice().getDisabled().value() == false);
            if (!((Boolean)this.config.getVoice().getMicrophoneDisabled().value()).booleanValue()) {
                this.disableMicrophoneButtons.get(0).setVisible(true);
                this.disableMicrophoneButtons.get(1).setVisible(false);
            }
        }, (button, matrices, mouseX, mouseY) -> this.parent.setTooltip(MinecraftTextComponent.translatable("gui.plasmovoice.toggle.voice", MinecraftTextComponent.translatable("gui.plasmovoice.toggle.currently", MinecraftTextComponent.translatable("gui.plasmovoice.toggle.disabled", new Object[0]).withStyle(MinecraftTextStyle.RED)).withStyle(MinecraftTextStyle.GRAY))), class_2960.method_12829((String)"plasmovoice:textures/icons/speaker_menu_disabled.png"), true);
        disableVoiceHide.setVisible((Boolean)this.config.getVoice().getDisabled().value() == false);
        disableVoiceShow.setVisible((Boolean)this.config.getVoice().getDisabled().value());
        this.disableMicrophoneButtons.add(disableMicrophoneHide);
        this.disableMicrophoneButtons.add(disableMicrophoneShow);
        this.parent.addWidget(disableMicrophoneHide);
        this.parent.addWidget(disableMicrophoneShow);
        this.disableVoiceButtons.add(disableVoiceHide);
        this.disableVoiceButtons.add(disableVoiceShow);
        this.parent.addWidget(disableVoiceHide);
        this.parent.addWidget(disableVoiceShow);
        this.getActiveTab().ifPresent(widget -> {
            widget.init();
            this.parent.addWidget(widget);
        });
    }

    public void removed() {
        if (this.aboutTabWidget != null) {
            this.aboutTabWidget.removed();
        }
        this.tabWidgets.forEach(TabWidget::removed);
    }

    public void renderButtons(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        int buttonX = 14;
        int buttonY = 36;
        if (!this.isMinimized()) {
            int buttonsWidth = this.getButtonsWidth();
            buttonX = this.parent.getWidth() / 2 - buttonsWidth / 2;
            buttonY = 8;
        }
        for (int index = 0; index < this.tabButtons.size(); ++index) {
            Button button = this.tabButtons.get(index);
            button.setActive(this.active == -1 || index != this.active);
            if (buttonX + button.getWidth() > this.parent.getWidth() - 8) {
                buttonX = 14;
                buttonY += 26;
            }
            button.setX(buttonX);
            buttonX += button.getWidth() + 4;
            button.setY(buttonY);
            UGraphics.enableDepth();
            UGraphics.depthFunc(519);
            button.render(stack, mouseX, mouseY, delta);
        }
        for (Button button : this.disableMicrophoneButtons) {
            button.render(stack, mouseX, mouseY, delta);
        }
        for (Button button : this.disableVoiceButtons) {
            button.render(stack, mouseX, mouseY, delta);
        }
    }

    public void renderTab(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        this.getActiveTab().ifPresent(tab -> tab.render(stack, mouseX, mouseY, delta));
    }

    public void renderBackground(@NotNull UMatrixStack stack) {
        int width = this.parent.getWidth();
        int height = this.getHeight();
        UGraphics.bindTexture(0, UMinecraft.getWorld() == null ? GuiWidget.MENU_LIST_BACKGROUND_LOCATION : GuiWidget.INWORLD_MENU_LIST_BACKGROUND_LOCATION);
        UGraphics.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        UGraphics.enableBlend();
        RenderUtil.blit(stack, 0, width, 0, height, 0, 0.0f, (float)width / 32.0f, 0.0f, (float)height / 32.0f);
        UGraphics.bindTexture(0, UMinecraft.getWorld() == null ? GuiWidget.FOOTER_SEPARATOR_LOCATION : GuiWidget.INWORLD_FOOTER_SEPARATOR_LOCATION);
        RenderUtil.blit(stack, 0, width, height, height + 2, 0, 0.0f, (float)width / 32.0f, 0.0f, 1.0f);
        UGraphics.disableBlend();
    }

    public void openTab(int index) {
        this.parent.getTestController().stop();
        this.getActiveTab().ifPresent(widget -> {
            widget.removed();
            this.parent.removeWidget((GuiWidgetListener)widget);
        });
        this.active = index;
        this.getActiveTab().ifPresent(widget -> {
            widget.init();
            this.parent.addWidget(widget);
        });
    }

    public void addTab(@NotNull MinecraftTextComponent name, @NotNull class_2960 iconLocation, @NotNull TabWidget tabWidget) {
        int elementIndex = this.tabWidgets.size();
        TabButton tabButton = new TabButton(0, 0, RenderUtil.getTextWidth(name) + 24, 20, name, iconLocation, btn -> this.openTab(elementIndex), Button.NO_TOOLTIP, true);
        this.parent.addWidget(tabButton);
        this.voiceClient.getEventBus().register(this.voiceClient, tabWidget);
        this.tabWidgets.add(tabWidget);
        this.tabButtons.add(tabButton);
    }

    public void clearTabs() {
        this.tabWidgets.forEach(tabWidget -> this.voiceClient.getEventBus().unregister((Object)this.voiceClient, tabWidget));
        this.tabWidgets.clear();
        this.tabButtons.clear();
    }

    public Optional<TabWidget> getActiveTab() {
        return this.active < 0 ? Optional.ofNullable(this.aboutTabWidget) : (this.tabWidgets.size() > 0 ? Optional.of(this.tabWidgets.get(this.active)) : Optional.empty());
    }

    public int getHeight() {
        if (this.isMinimized()) {
            return 36 + this.getLines() * 28;
        }
        return 36;
    }

    public boolean isMinimized() {
        int titleWidth = 14 + RenderUtil.getTextWidth(this.parent.getTitle()) + 4;
        int buttonsWidth = this.getButtonsWidth();
        int buttonX = this.parent.getWidth() / 2 - buttonsWidth / 2;
        if (buttonX < titleWidth) {
            return true;
        }
        int disableButtonsWidth = 62;
        return titleWidth + buttonsWidth + disableButtonsWidth > this.parent.getWidth();
    }

    public int getLines() {
        int buttonX = 14;
        int lines = 1;
        for (Button button : this.tabButtons) {
            if (buttonX + button.getWidth() > this.parent.getWidth() - 8) {
                buttonX = 14;
                ++lines;
            }
            buttonX += button.getWidth() + 4;
        }
        return lines;
    }

    public int getButtonsWidth() {
        int width = this.tabButtons.stream().map(GuiAbstractWidget::getWidth).reduce(0, Integer::sum);
        return width += (this.tabButtons.size() - 1) * 4;
    }

    public int getActive() {
        return this.active;
    }
}

