/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.config.keybind.KeyBinding;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.key.MouseScrollEvent;
import su.plo.voice.universal.UMinecraft;
import su.plo.voice.universal.UScreen;

public final class PlayerVolumeAction {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private class_1657 focusedPlayer;
    private long lastScroll;

    public PlayerVolumeAction(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
        voiceClient.getKeyBindings().getKeyBinding("key.plasmovoice.general.action").ifPresent(key -> key.addPressListener(this::onButton));
    }

    public boolean isShown(@NotNull class_1657 player) {
        return this.focusedPlayer != null && this.focusedPlayer.method_5667().equals(player.method_5667()) && this.lastScroll != 0L && System.currentTimeMillis() - this.lastScroll < 1000L;
    }

    @EventSubscribe
    public void onScroll(@NotNull MouseScrollEvent event) {
        if (this.focusedPlayer != null && UScreen.getCurrentScreen() == null) {
            this.lastScroll = System.currentTimeMillis();
            DoubleConfigEntry volume = this.config.getVoice().getVolumes().getVolume("source_" + String.valueOf(this.focusedPlayer.method_5667()));
            double value = (Double)volume.value() + (event.getVertical() > 0.0 ? 0.05 : -0.05);
            volume.set((double)(Math.round(value * volume.getMax() * 100.0 / 5.0) * 5L) / (volume.getMax() * 100.0));
            event.setCancelled(true);
        }
    }

    private void onButton(@NotNull KeyBinding.Action action) {
        if (!this.voiceClient.getServerConnection().isPresent()) {
            return;
        }
        if (action == KeyBinding.Action.DOWN) {
            ServerConnection serverConnection = this.voiceClient.getServerConnection().get();
            this.getPlayerBySight().filter(player -> serverConnection.getPlayerById(player.method_5667()).isPresent()).ifPresent(player -> {
                this.focusedPlayer = player;
            });
        } else if (action == KeyBinding.Action.UP) {
            this.focusedPlayer = null;
            this.lastScroll = 0L;
        }
    }

    private Optional<class_1657> getPlayerBySight() {
        class_638 level = UMinecraft.getWorld();
        class_746 player = UMinecraft.getPlayer();
        if (level == null || player == null) {
            return Optional.empty();
        }
        class_243 playerPos = player.method_33571();
        class_243 rotVector = player.method_5720();
        for (int i = 0; i < (Integer)UMinecraft.getSettings().method_42503().method_41753() * 16; ++i) {
            playerPos = playerPos.method_1019(rotVector);
            class_2338 blockPos = new class_2338((int)Math.floor(playerPos.field_1352), (int)Math.floor(playerPos.field_1351), (int)Math.floor(playerPos.field_1350));
            class_2680 state = level.method_8320(blockPos);
            boolean isSolid = state.method_26216((class_1922)level, blockPos);
            if (!state.method_26215() && isSolid) break;
            class_238 box = class_238.method_30048((class_243)playerPos.method_1023(0.0, 1.0, 0.0), (double)1.0, (double)2.0, (double)1.0);
            for (class_1657 playerEntity : level.method_18456()) {
                if (!box.method_1008(playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321()) || playerEntity.method_5756((class_1657)player) || player.method_5667().equals(playerEntity.method_5667())) continue;
                return Optional.of(playerEntity);
            }
        }
        return Optional.empty();
    }
}

