/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.connection;

import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.util.Optional;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.connection.ModServerConnection;
import su.plo.voice.codec.PacketTcpPayload;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketHandler;
import su.plo.voice.proto.packets.tcp.PacketTcpCodec;

public final class ModClientChannelHandler
implements ClientPlayNetworking.PlayPayloadHandler<PacketTcpPayload> {
    private final BaseVoiceClient voiceClient;
    private ModServerConnection connection;

    public ModClientChannelHandler(@NotNull BaseVoiceClient voiceClient) {
        this.voiceClient = voiceClient;
    }

    public void close() {
        if (this.connection != null) {
            this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this.connection);
            this.connection = null;
        }
    }

    public Optional<ServerConnection> getConnection() {
        return Optional.ofNullable(this.connection);
    }

    public void receive(PacketTcpPayload payload, ClientPlayNetworking.Context context) {
        class_2535 connection = context.client().method_1562().method_48296();
        this.receive(connection, payload.getPacket());
    }

    private void receive(class_2535 connection, Packet<PacketHandler> packet) {
        if (this.connection == null || connection != this.connection.getConnection()) {
            if (this.connection != null) {
                this.close();
            }
            try {
                this.connection = new ModServerConnection(this.voiceClient, connection);
                this.connection.generateKeyPair();
                this.voiceClient.getEventBus().register(this.voiceClient, this.connection);
            }
            catch (Exception e) {
                BaseVoice.LOGGER.error("Failed to initialize server connection: {}", (Object)e.toString());
                e.printStackTrace();
                return;
            }
        }
        this.connection.handle(packet);
    }

    private void receive(class_2535 connection, class_2540 buf) {
        byte[] data = ByteBufUtil.getBytes((ByteBuf)buf.duplicate());
        try {
            PacketTcpCodec.decode(ByteStreams.newDataInput((byte[])data)).ifPresent(packet -> this.receive(connection, (Packet<PacketHandler>)packet));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

