/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.sun.jna.Platform;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.config.entry.ConfigEntry;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AudioDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.DeviceFactory;
import su.plo.voice.api.client.audio.device.DeviceManager;
import su.plo.voice.api.client.audio.device.DeviceType;
import su.plo.voice.api.client.audio.device.InputDevice;
import su.plo.voice.api.client.audio.device.OutputDevice;
import su.plo.voice.api.client.audio.device.source.AlSource;
import su.plo.voice.api.client.audio.device.source.SourceGroup;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.util.Params;
import su.plo.voice.client.audio.device.source.VoiceOutputSourceGroup;
import su.plo.voice.client.audio.filter.GainFilter;
import su.plo.voice.client.audio.filter.NoiseSuppressionFilter;
import su.plo.voice.client.audio.filter.StereoToMonoFilter;
import su.plo.voice.client.config.VoiceClientConfig;

public final class VoiceDeviceManager
implements DeviceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(VoiceDeviceManager.class);
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final List<AudioDevice> inputDevices = new CopyOnWriteArrayList<AudioDevice>();
    private final List<AudioDevice> outputDevices = new CopyOnWriteArrayList<AudioDevice>();
    private ScheduledFuture<?> job;
    private String failedOutputDevices = "";
    private String failedInputDevices = "";

    @Override
    public void add(@NotNull AudioDevice device) {
        Preconditions.checkNotNull((Object)device, (Object)"device cannot be null");
        List<AudioDevice> devices = this.getDevicesList(device);
        if (devices == this.inputDevices && devices.size() > 0) {
            throw new IllegalStateException("Multiple input devices currently are not supported. Use DeviceManager::replace to replace the current input device");
        }
        if (devices.contains(device)) {
            return;
        }
        this.voiceClient.getEventBus().register(this.voiceClient, device);
        devices.add(device);
    }

    @Override
    public void replace(@Nullable AudioDevice oldDevice, @NotNull AudioDevice newDevice) {
        Preconditions.checkNotNull((Object)newDevice, (Object)"newDevice cannot be null");
        List<AudioDevice> devices = this.getDevicesList(newDevice);
        if (oldDevice != null) {
            if (devices != this.getDevicesList(oldDevice)) {
                throw new IllegalArgumentException("Devices are not implementing the same interface");
            }
            int index = devices.indexOf(oldDevice);
            if (index < 0) {
                throw new IllegalArgumentException("oldDevice not found in device list");
            }
            devices.set(index, newDevice);
        } else if (devices.size() > 0) {
            oldDevice = devices.get(0);
            devices.set(0, newDevice);
            oldDevice.close();
        } else {
            devices.add(newDevice);
        }
        if (oldDevice != null) {
            this.voiceClient.getEventBus().unregister((Object)this.voiceClient, oldDevice);
        }
        this.voiceClient.getEventBus().register(this.voiceClient, newDevice);
    }

    @Override
    public void remove(@NotNull AudioDevice device) {
        Preconditions.checkNotNull((Object)device, (Object)"device cannot be null");
        this.getDevicesList(device).remove(device);
        this.voiceClient.getEventBus().unregister((Object)this.voiceClient, device);
    }

    @Override
    public void clear(@Nullable DeviceType type) {
        if (type == DeviceType.INPUT) {
            this.inputDevices.forEach(device -> {
                device.close();
                this.voiceClient.getEventBus().unregister((Object)this.voiceClient, device);
            });
            this.inputDevices.clear();
        } else if (type == DeviceType.OUTPUT) {
            this.outputDevices.forEach(device -> {
                device.close();
                this.voiceClient.getEventBus().unregister((Object)this.voiceClient, device);
            });
            this.outputDevices.clear();
        } else {
            this.getDevices(null).forEach(device -> {
                device.close();
                this.voiceClient.getEventBus().unregister((Object)this.voiceClient, device);
            });
            this.inputDevices.clear();
            this.outputDevices.clear();
        }
    }

    @Override
    public <T extends AudioDevice> Collection<T> getDevices(DeviceType type) {
        if (type == DeviceType.INPUT) {
            return this.inputDevices;
        }
        if (type == DeviceType.OUTPUT) {
            return this.outputDevices;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        return builder.addAll(this.inputDevices).addAll(this.outputDevices).build();
    }

    @Override
    public SourceGroup createSourceGroup(@Nullable DeviceType type) {
        if (type == DeviceType.OUTPUT) {
            return new VoiceOutputSourceGroup(this);
        }
        throw new IllegalArgumentException(String.valueOf((Object)type) + " not supported");
    }

    @Override
    public InputDevice openInputDevice(@Nullable AudioFormat format, @NotNull Params params) throws Exception {
        InputDevice device;
        if (Platform.isMac() && !((Boolean)this.config.getVoice().getUseJavaxInput().value()).booleanValue()) {
            this.config.getVoice().getUseJavaxInput().set(true);
            this.config.save(true);
        }
        if (((Boolean)this.config.getVoice().getUseJavaxInput().value()).booleanValue() && ((Boolean)this.config.getVoice().getStereoCapture().value()).booleanValue()) {
            this.config.getVoice().getStereoCapture().set(false);
            this.config.getVoice().getStereoCapture().setDisabled(true);
            this.config.save(true);
        }
        if (format == null) {
            if (!this.voiceClient.getServerInfo().isPresent()) {
                throw new IllegalStateException("Not connected");
            }
            ServerInfo serverInfo = this.voiceClient.getServerInfo().get();
            format = serverInfo.getVoiceInfo().getFormat((Boolean)this.config.getVoice().getStereoCapture().value());
        }
        if (((Boolean)this.config.getVoice().getUseJavaxInput().value()).booleanValue()) {
            device = this.openJavaxInputDevice(format);
        } else {
            try {
                device = this.openAlInputDevice(format);
            }
            catch (Exception e) {
                BaseVoice.LOGGER.error("Failed to open OpenAL input device, falling back to Javax input device", (Throwable)e);
                device = this.openJavaxInputDevice(format);
            }
        }
        device.addFilter(new StereoToMonoFilter(this.config.getVoice().getStereoCapture()));
        device.addFilter(new GainFilter(this.config.getVoice().getMicrophoneVolume()));
        device.addFilter(new NoiseSuppressionFilter((int)format.getSampleRate(), this.config.getVoice().getNoiseSuppression()));
        return device;
    }

    @Override
    public OutputDevice<AlSource> openOutputDevice(@Nullable AudioFormat format, @NotNull Params params) throws Exception {
        DeviceFactory deviceFactory = this.voiceClient.getDeviceFactoryManager().getDeviceFactory("AL_OUTPUT").orElseThrow(() -> new DeviceException("OpenAL output device factory is not initialized"));
        if (format == null) {
            if (!this.voiceClient.getServerInfo().isPresent()) {
                throw new IllegalStateException("Not connected");
            }
            ServerInfo serverInfo = this.voiceClient.getServerInfo().get();
            format = serverInfo.getVoiceInfo().getFormat(false);
        }
        String deviceName = this.getDeviceName(deviceFactory, this.config.getVoice().getOutputDevice());
        return (OutputDevice)deviceFactory.openDevice(format, deviceName);
    }

    public void startJob() {
        this.job = this.voiceClient.getBackgroundExecutor().scheduleAtFixedRate(() -> {
            try {
                this.tickJob();
            }
            catch (DeviceException e) {
                e.printStackTrace();
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public void stopJob() {
        if (this.job != null) {
            this.job.cancel(false);
        }
    }

    private void tickJob() throws DeviceException {
        String deviceNamesString;
        ImmutableList<String> deviceNames;
        DeviceFactory outputFactory = this.voiceClient.getDeviceFactoryManager().getDeviceFactory("AL_OUTPUT").orElseThrow(() -> new DeviceException("OpenAL output device factory is not registered"));
        String inputFactoryName = (Boolean)this.config.getVoice().getUseJavaxInput().value() != false ? "JAVAX_INPUT" : "AL_INPUT";
        DeviceFactory inputFactory = this.voiceClient.getDeviceFactoryManager().getDeviceFactory(inputFactoryName).orElseThrow(() -> new IllegalStateException("OpenAL input factory is not registered"));
        if (this.outputDevices.isEmpty()) {
            deviceNames = outputFactory.getDeviceNames();
            deviceNamesString = String.join((CharSequence)"\n", deviceNames);
            if (deviceNames.size() > 0 && !deviceNamesString.equals(this.failedOutputDevices)) {
                try {
                    this.add(this.voiceClient.getDeviceManager().openOutputDevice(null, Params.EMPTY));
                    this.failedOutputDevices = "";
                }
                catch (Exception e) {
                    LOGGER.error("Failed to open primary OpenAL output device", (Throwable)e);
                    this.failedOutputDevices = deviceNamesString;
                }
                if (!this.voiceClient.getAudioCapture().isActive() && !this.inputDevices.isEmpty()) {
                    this.voiceClient.getAudioCapture().start();
                }
                this.voiceClient.getSourceManager().clear();
            }
        } else {
            this.outputDevices.stream().filter(device -> !device.isOpen()).forEach(device -> {
                device.close();
                this.remove((AudioDevice)device);
            });
        }
        if (this.inputDevices.isEmpty()) {
            deviceNames = inputFactory.getDeviceNames();
            deviceNamesString = String.join((CharSequence)"\n", deviceNames);
            if (deviceNames.size() > 0 && !deviceNamesString.equals(this.failedInputDevices) && !((Boolean)this.config.getVoice().getDisableInputDevice().value()).booleanValue()) {
                try {
                    this.replace(null, this.voiceClient.getDeviceManager().openInputDevice(null, Params.EMPTY));
                    this.failedInputDevices = "";
                }
                catch (Exception e) {
                    LOGGER.error("Failed to open input device", (Throwable)e);
                    this.failedInputDevices = deviceNamesString;
                }
                if (!this.voiceClient.getAudioCapture().isActive()) {
                    this.voiceClient.getAudioCapture().start();
                }
            }
        } else {
            this.inputDevices.stream().filter(device -> !device.isOpen()).forEach(device -> {
                device.close();
                this.remove((AudioDevice)device);
            });
        }
    }

    private InputDevice openAlInputDevice(@NotNull AudioFormat format) throws Exception {
        DeviceFactory deviceFactory = this.voiceClient.getDeviceFactoryManager().getDeviceFactory("AL_INPUT").orElseThrow(() -> new IllegalStateException("OpenAL input factory is not registered"));
        String deviceName = this.getDeviceName(deviceFactory, this.config.getVoice().getInputDevice());
        return (InputDevice)deviceFactory.openDevice(format, deviceName);
    }

    private InputDevice openJavaxInputDevice(@NotNull AudioFormat format) throws Exception {
        DeviceFactory deviceFactory = this.voiceClient.getDeviceFactoryManager().getDeviceFactory("JAVAX_INPUT").orElseThrow(() -> new IllegalStateException("Javax input factory is not registered"));
        String deviceName = this.getDeviceName(deviceFactory, this.config.getVoice().getInputDevice());
        return (InputDevice)deviceFactory.openDevice(format, deviceName);
    }

    @NotNull
    private String getDeviceName(DeviceFactory deviceFactory, ConfigEntry<String> configEntry) {
        String deviceName = configEntry.value();
        if (!Strings.isNullOrEmpty((String)deviceName) && !deviceFactory.getDeviceNames().contains((Object)deviceName)) {
            deviceName = deviceFactory.getDefaultDeviceName();
            configEntry.set("");
        } else if (Strings.isNullOrEmpty((String)deviceName)) {
            deviceName = deviceFactory.getDefaultDeviceName();
        }
        return deviceName;
    }

    private List<AudioDevice> getDevicesList(AudioDevice device) {
        List<AudioDevice> devices;
        if (device instanceof InputDevice) {
            devices = this.inputDevices;
        } else if (device instanceof OutputDevice) {
            devices = this.outputDevices;
        } else {
            throw new IllegalArgumentException("device not implements InputDevice or OutputDevice");
        }
        return devices;
    }

    public VoiceDeviceManager(PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
    }
}

