/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.server.entity;

import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5894;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.server.chat.ServerTextConverter;
import su.plo.lib.api.server.entity.MinecraftServerEntity;
import su.plo.lib.api.server.entity.MinecraftServerPlayerEntity;
import su.plo.lib.api.server.permission.PermissionTristate;
import su.plo.lib.api.server.world.MinecraftServerWorld;
import su.plo.lib.api.server.world.ServerPos3d;
import su.plo.lib.mod.client.texture.ResourceCache;
import su.plo.lib.mod.entity.ModPlayer;
import su.plo.lib.mod.server.ModServerLib;
import su.plo.lib.mod.server.utils.ServerPlayerKt;
import su.plo.voice.codec.PacketServicePayload;
import su.plo.voice.codec.PacketTcpPayload;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketHandler;
import su.plo.voice.proto.packets.tcp.PacketTcpCodec;

public final class ModServerPlayer
extends ModPlayer<class_3222>
implements MinecraftServerPlayerEntity {
    private final ModServerLib minecraftServer;
    private final ServerTextConverter<class_2561> textConverter;
    private final ResourceCache resources;
    private final Set<String> registeredChannels = Sets.newCopyOnWriteArraySet();
    private String language = "en_us";
    private MinecraftServerEntity spectatorTarget;

    public ModServerPlayer(@NotNull ModServerLib minecraftServer, @NotNull ServerTextConverter<class_2561> textConverter, @NotNull ResourceCache resources, @NotNull class_3222 player) {
        super(player);
        this.minecraftServer = minecraftServer;
        this.textConverter = textConverter;
        this.resources = resources;
    }

    @Override
    @NotNull
    public ServerPos3d getServerPosition() {
        return new ServerPos3d(this.minecraftServer.getWorld(ServerPlayerKt.serverLevel((class_3222)this.instance)), ((class_3222)this.instance).method_19538().method_10216(), ((class_3222)this.instance).method_19538().method_10214(), ((class_3222)this.instance).method_19538().method_10215(), ((class_3222)this.instance).method_36455(), ((class_3222)this.instance).method_36454());
    }

    @Override
    @NotNull
    public ServerPos3d getServerPosition(@NotNull ServerPos3d position) {
        position.setWorld(this.minecraftServer.getWorld(ServerPlayerKt.serverLevel((class_3222)this.instance)));
        position.setX(((class_3222)this.instance).method_19538().method_10216());
        position.setY(((class_3222)this.instance).method_19538().method_10214());
        position.setZ(((class_3222)this.instance).method_19538().method_10215());
        position.setYaw(((class_3222)this.instance).method_36455());
        position.setPitch(((class_3222)this.instance).method_36454());
        return position;
    }

    @Override
    @NotNull
    public MinecraftServerWorld getWorld() {
        return this.minecraftServer.getWorld(ServerPlayerKt.serverLevel((class_3222)this.instance));
    }

    @Override
    public boolean isOnline() {
        return !((class_3222)this.instance).method_14239();
    }

    @Override
    @NotNull
    public MinecraftGameProfile getGameProfile() {
        return this.minecraftServer.getGameProfile(((class_3222)this.instance).method_5667()).orElseThrow(() -> new IllegalStateException("Game profile not found"));
    }

    @Override
    public void sendPacket(@NotNull String channel, byte[] data) {
        try {
            switch (channel) {
                case "plasmo:voice/v2": {
                    Packet<PacketHandler> packet = PacketTcpCodec.decode(ByteStreams.newDataInput((byte[])data)).orElseThrow(() -> new IOException("data is not Plasmo Voice packet"));
                    ((class_3222)this.instance).field_13987.method_14364(ServerPlayNetworking.createS2CPacket((class_8710)new PacketTcpPayload(packet)));
                    break;
                }
                case "plasmo:voice/v2/service": {
                    ((class_3222)this.instance).field_13987.method_14364(ServerPlayNetworking.createS2CPacket((class_8710)new PacketServicePayload(data)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This method is now not supported for custom channels due to 1.20.5 changes. It'll be fixed in PV 2.1.x");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void kick(@NotNull MinecraftTextComponent reason) {
        ((class_3222)this.instance).field_13987.method_52396(this.textConverter.convert(this, reason));
    }

    @Override
    public void sendMessage(@NotNull MinecraftTextComponent text) {
        ((class_3222)this.instance).method_43496(this.textConverter.convert(this, text));
    }

    @Override
    public void sendActionBar(@NotNull MinecraftTextComponent text) {
        ((class_3222)this.instance).field_13987.method_14364((class_2596)new class_5894(this.textConverter.convert(this, text)));
    }

    @Override
    public boolean canSee(@NotNull MinecraftServerPlayerEntity player) {
        class_3222 serverPlayer = (class_3222)player.getInstance();
        if (serverPlayer.method_7325()) {
            return ((class_3222)this.instance).method_7325();
        }
        return true;
    }

    @Override
    public Collection<String> getRegisteredChannels() {
        return this.registeredChannels;
    }

    @Override
    public Optional<MinecraftServerEntity> getSpectatorTarget() {
        if (((class_3222)this.instance).method_14242() == this.instance) {
            this.spectatorTarget = null;
        } else if (this.spectatorTarget == null || !((class_3222)this.instance).method_14242().equals(this.spectatorTarget.getInstance())) {
            this.spectatorTarget = this.minecraftServer.getEntity(((class_3222)this.instance).method_14242());
        }
        return Optional.ofNullable(this.spectatorTarget);
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        if (this.minecraftServer.getPermissions() == null) {
            return false;
        }
        return this.minecraftServer.getPermissions().hasPermission(this.instance, permission);
    }

    @Override
    @NotNull
    public PermissionTristate getPermission(@NotNull String permission) {
        if (this.minecraftServer.getPermissions() == null) {
            return PermissionTristate.UNDEFINED;
        }
        return this.minecraftServer.getPermissions().getPermission(this.instance, permission);
    }

    public void addChannel(@NotNull String channel) {
        this.registeredChannels.add(channel);
    }

    public void removeChannel(@NotNull String channel) {
        this.registeredChannels.remove(channel);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

