/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.server;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.server.MinecraftServerLib;
import su.plo.lib.api.server.entity.MinecraftServerEntity;
import su.plo.lib.api.server.entity.MinecraftServerPlayerEntity;
import su.plo.lib.api.server.event.player.PlayerQuitEvent;
import su.plo.lib.api.server.permission.PermissionsManager;
import su.plo.lib.api.server.world.MinecraftServerWorld;
import su.plo.lib.mod.chat.ComponentTextConverter;
import su.plo.lib.mod.client.texture.ResourceCache;
import su.plo.lib.mod.server.chat.ServerComponentTextConverter;
import su.plo.lib.mod.server.command.ModCommandManager;
import su.plo.lib.mod.server.entity.ModServerEntity;
import su.plo.lib.mod.server.entity.ModServerPlayer;
import su.plo.lib.mod.server.world.ModServerWorld;
import su.plo.voice.api.server.config.ServerLanguages;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.server.player.PermissionSupplier;

public final class ModServerLib
implements MinecraftServerLib {
    public static ModServerLib INSTANCE;
    private final Map<class_3218, MinecraftServerWorld> worldByInstance = Maps.newConcurrentMap();
    private final Map<UUID, MinecraftServerPlayerEntity> playerById = Maps.newConcurrentMap();
    private MinecraftServer server;
    private PermissionSupplier permissions;
    private final ServerComponentTextConverter textConverter;
    private final ResourceCache resources = new ResourceCache();
    private final ModCommandManager commandManager;
    private final PermissionsManager permissionsManager = new PermissionsManager();
    private ScheduledExecutorService backgroundExecutor;
    private ScheduledFuture<?> worldCleanupTask;

    public ModServerLib(@NotNull Supplier<ServerLanguages> languagesSupplier) {
        this.textConverter = new ServerComponentTextConverter(new ComponentTextConverter(), languagesSupplier);
        this.commandManager = new ModCommandManager(this, this.textConverter);
        PlayerQuitEvent.INSTANCE.registerListener(player -> this.playerById.remove(player.getUUID()));
    }

    @Override
    public void onInitialize() {
        INSTANCE = this;
        this.backgroundExecutor = Executors.newSingleThreadScheduledExecutor();
        this.worldCleanupTask = this.backgroundExecutor.scheduleAtFixedRate(this::worldsCleanupTick, 0L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void onShutdown() {
        this.server = null;
        this.permissions = null;
        this.commandManager.clear();
        this.permissionsManager.clear();
        this.worldCleanupTask.cancel(false);
        this.backgroundExecutor.shutdown();
    }

    @Override
    public void executeInMainThread(@NotNull Runnable runnable) {
        this.server.execute(runnable);
    }

    @Override
    @NotNull
    public MinecraftServerWorld getWorld(@NotNull Object instance) {
        if (!(instance instanceof class_3218)) {
            throw new IllegalArgumentException("instance is not " + String.valueOf(class_3218.class));
        }
        return this.worldByInstance.computeIfAbsent((class_3218)instance, level -> new ModServerWorld(level.method_27983().method_29177(), (class_3218)level));
    }

    @Override
    public Collection<MinecraftServerWorld> getWorlds() {
        return StreamSupport.stream(this.server.method_3738().spliterator(), false).map(this::getWorld).toList();
    }

    @Override
    @NotNull
    public MinecraftServerPlayerEntity getPlayerByInstance(@NotNull Object instance) {
        if (!(instance instanceof class_3222)) {
            throw new IllegalArgumentException("instance is not " + String.valueOf(class_3222.class));
        }
        class_3222 serverInstance = (class_3222)instance;
        MinecraftServerPlayerEntity serverPlayer = this.playerById.get(serverInstance.method_5667());
        if (serverPlayer == null) {
            serverPlayer = new ModServerPlayer(this, this.textConverter, this.resources, serverInstance);
            this.playerById.put(serverInstance.method_5667(), serverPlayer);
        } else if (serverPlayer.getInstance() != serverInstance) {
            ((ModServerPlayer)serverPlayer).setInstance(serverInstance);
        }
        return serverPlayer;
    }

    @Override
    public Optional<MinecraftServerPlayerEntity> getPlayerByName(@NotNull String name) {
        class_3222 player = this.server.method_3760().method_14566(name);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(this.getPlayerByInstance(player));
    }

    @Override
    public Optional<MinecraftServerPlayerEntity> getPlayerById(@NotNull UUID playerId) {
        MinecraftServerPlayerEntity serverPlayer = this.playerById.get(playerId);
        if (serverPlayer != null) {
            return Optional.of(serverPlayer);
        }
        class_3222 player = this.server.method_3760().method_14602(playerId);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(this.getPlayerByInstance(player));
    }

    @Override
    public Optional<MinecraftGameProfile> getGameProfile(@NotNull UUID playerId) {
        return this.server.method_3793().method_14512(playerId).map(this::getGameProfile);
    }

    @Override
    public Optional<MinecraftGameProfile> getGameProfile(@NotNull String name) {
        return this.server.method_3793().method_14515(name).map(this::getGameProfile);
    }

    private MinecraftGameProfile getGameProfile(@NotNull GameProfile gameProfile) {
        return new MinecraftGameProfile(gameProfile.getId(), gameProfile.getName(), gameProfile.getProperties().values().stream().map(property -> new MinecraftGameProfile.Property(property.name(), property.value(), property.signature())).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public Collection<MinecraftServerPlayerEntity> getPlayers() {
        return this.playerById.values();
    }

    @Override
    @NotNull
    public MinecraftServerEntity getEntity(@NotNull Object instance) {
        if (!(instance instanceof class_1297)) {
            throw new IllegalArgumentException("instance is not " + String.valueOf(class_1297.class));
        }
        return new ModServerEntity(this, (class_1297)instance);
    }

    @Override
    public int getPort() {
        return this.server.method_3756();
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.server.method_3827();
    }

    private void worldsCleanupTick() {
        Set worlds = StreamSupport.stream(this.server.method_3738().spliterator(), false).collect(Collectors.toSet());
        this.worldByInstance.keySet().stream().filter(world -> !worlds.contains(world)).forEach(this.worldByInstance::remove);
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    public void setPermissions(PermissionSupplier permissions) {
        this.permissions = permissions;
    }

    public PermissionSupplier getPermissions() {
        return this.permissions;
    }

    public ServerComponentTextConverter getTextConverter() {
        return this.textConverter;
    }

    public ModCommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public PermissionsManager getPermissionsManager() {
        return this.permissionsManager;
    }
}

