/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.screen;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.gui.widget.GuiWidgetListener;
import su.plo.voice.universal.UKeyboard;

public interface GuiScreenListener
extends GuiWidgetListener {
    public List<? extends GuiWidgetListener> widgets();

    default public Optional<GuiWidgetListener> getWidgetAt(double mouseX, double mouseY) {
        GuiWidgetListener guiEventListener;
        Iterator<? extends GuiWidgetListener> iter = this.widgets().iterator();
        do {
            if (iter.hasNext()) continue;
            return Optional.empty();
        } while (!(guiEventListener = iter.next()).isMouseOver(mouseX, mouseY));
        return Optional.of(guiEventListener);
    }

    @Override
    default public boolean mouseClicked(double mouseX, double mouseY, int button) {
        GuiWidgetListener widget;
        Iterator<? extends GuiWidgetListener> iter = this.widgets().iterator();
        do {
            if (iter.hasNext()) continue;
            return false;
        } while (!(widget = iter.next()).mouseClicked(mouseX, mouseY, button));
        this.setFocused(widget);
        if (button == 0) {
            this.setDragging(true);
        }
        return true;
    }

    @Override
    default public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        if (this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return this.getWidgetAt(mouseX, mouseY).filter(element -> element.mouseReleased(mouseX, mouseY, button)).isPresent();
    }

    @Override
    default public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return this.getWidgetAt(mouseX, mouseY).filter(guiEventListener -> guiEventListener.mouseScrolled(mouseX, mouseY, delta)).isPresent();
    }

    @Override
    default public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    default public boolean keyPressed(int keyCode, @Nullable UKeyboard.Modifiers modifiers) {
        return this.getFocused() != null && this.getFocused().keyPressed(keyCode, modifiers);
    }

    @Override
    default public boolean charTyped(char typedChar,  @Nullable UKeyboard.Modifiers modifiers) {
        return this.getFocused() != null && this.getFocused().charTyped(typedChar, modifiers);
    }

    @Override
    default public boolean keyReleased(int keyCode, char typedChar, @Nullable UKeyboard.Modifiers modifiers) {
        return this.getFocused() != null && this.getFocused().keyReleased(keyCode, typedChar, modifiers);
    }

    @Override
    default public boolean changeFocus(boolean lookForwards) {
        boolean bl2;
        GuiWidgetListener guiEventListener = this.getFocused();
        boolean bl = bl2 = guiEventListener != null;
        if (!bl2 || !guiEventListener.changeFocus(lookForwards)) {
            GuiWidgetListener guiEventListener2;
            Supplier<GuiWidgetListener> var11;
            BooleanSupplier var10000;
            List<? extends GuiWidgetListener> list = this.widgets();
            int i = list.indexOf(guiEventListener);
            int j = bl2 && i >= 0 ? i + (lookForwards ? 1 : 0) : (lookForwards ? 0 : list.size());
            ListIterator<? extends GuiWidgetListener> listIterator2 = list.listIterator(j);
            if (lookForwards) {
                Objects.requireNonNull(listIterator2);
                var10000 = listIterator2::hasNext;
            } else {
                Objects.requireNonNull(listIterator2);
                var10000 = listIterator2::hasPrevious;
            }
            BooleanSupplier booleanSupplier = var10000;
            if (lookForwards) {
                Objects.requireNonNull(listIterator2);
                var11 = listIterator2::next;
            } else {
                Objects.requireNonNull(listIterator2);
                var11 = listIterator2::previous;
            }
            Supplier<GuiWidgetListener> supplier = var11;
            do {
                if (booleanSupplier.getAsBoolean()) continue;
                this.setFocused(null);
                return false;
            } while (!(guiEventListener2 = supplier.get()).changeFocus(lookForwards));
            this.setFocused(guiEventListener2);
        }
        return true;
    }

    public boolean isDragging();

    public void setDragging(boolean var1);

    @Nullable
    public GuiWidgetListener getFocused();

    public void setFocused(@Nullable GuiWidgetListener var1);
}

