/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.chat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import lombok.NonNull;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftTextClickEvent;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.chat.MinecraftTextConverter;
import su.plo.lib.api.chat.MinecraftTextHoverEvent;
import su.plo.lib.api.chat.MinecraftTextStyle;
import su.plo.lib.api.chat.MinecraftTranslatableText;

public final class ComponentTextConverter
implements MinecraftTextConverter<class_2561> {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    @Override
    @NotNull
    public String convertToJson(@NotNull class_2561 text) {
        return GSON.toJson((JsonElement)class_8824.field_46597.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)text).getOrThrow(JsonParseException::new));
    }

    @Override
    public class_2561 convertFromJson(@NotNull String json2) {
        JsonElement jsonElement = JsonParser.parseString((String)json2);
        return jsonElement == null ? null : (class_2561)class_8824.field_46597.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonParseException::new);
    }

    @Override
    public class_2561 convert(@NotNull MinecraftTextComponent text) {
        class_5250 component = text instanceof MinecraftTranslatableText ? this.convertTranslatable((MinecraftTranslatableText)text) : class_2561.method_43470((String)text.toString());
        component = this.applyStyles(component, text.styles());
        component = this.applyClickEvent(component, text.clickEvent());
        component = this.applyHoverEvent(component, text.hoverEvent());
        for (MinecraftTextComponent sibling : text.siblings()) {
            component.method_10852(this.convert(sibling));
        }
        return component;
    }

    private class_5250 convertTranslatable(@NotNull MinecraftTranslatableText text) {
        Object[] args2 = new Object[text.getArgs().length];
        for (int i = 0; i < args2.length; ++i) {
            Object arg = text.getArgs()[i];
            args2[i] = arg instanceof MinecraftTextComponent ? this.convert((MinecraftTextComponent)arg) : arg;
        }
        return class_2561.method_43469((String)text.getKey(), (Object[])args2);
    }

    private class_5250 applyClickEvent(@NotNull class_5250 component, @Nullable MinecraftTextClickEvent clickEvent) {
        if (clickEvent == null) {
            return component;
        }
        component.method_10862(component.method_10866().method_10958(new class_2558(class_2558.class_2559.valueOf((String)clickEvent.action().name()), clickEvent.value())));
        return component;
    }

    private class_5250 applyHoverEvent(@NotNull class_5250 component, @Nullable MinecraftTextHoverEvent hoverEvent) {
        if (hoverEvent == null) {
            return component;
        }
        if (hoverEvent.action() == MinecraftTextHoverEvent.Action.SHOW_TEXT) {
            component.method_10862(component.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)this.convert((MinecraftTextComponent)hoverEvent.value()))));
        }
        return component;
    }

    private class_5250 applyStyles(@NonNull class_5250 component, @NotNull List<MinecraftTextStyle> styles) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (styles.isEmpty()) {
            return component;
        }
        component.method_10862(component.method_10866().method_27705((class_124[])styles.stream().map(this::convertStyle).toArray(class_124[]::new)));
        return component;
    }

    private class_124 convertStyle(@NotNull MinecraftTextStyle style) {
        return class_124.valueOf((String)style.name());
    }
}

