/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.mixin.IMixinAbstractFurnaceBlockEntity;
import fi.dy.masa.minihud.util.DataStorage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2609;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_4482;
import net.minecraft.class_5250;
import net.minecraft.class_5762;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9275;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class MiscUtils {
    private static final Random RAND = new Random();
    private static final int[] AXOLOTL_COLORS = new int[]{16762860, 9202768, 16438299, 15267835, 11974142};

    public static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static double intAverage(int[] values) {
        long sum = 0L;
        for (int value : values) {
            sum += (long)value;
        }
        return (double)sum / (double)values.length;
    }

    public static long longAverage(long[] values) {
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return sum / (long)values.length;
    }

    public static boolean canSlimeSpawnAt(int posX, int posZ, long worldSeed) {
        return MiscUtils.canSlimeSpawnInChunk(posX >> 4, posZ >> 4, worldSeed);
    }

    public static boolean canSlimeSpawnInChunk(int chunkX, int chunkZ, long worldSeed) {
        long slimeSeed = 987234911L;
        long rngSeed = worldSeed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ slimeSeed;
        RAND.setSeed(rngSeed);
        return RAND.nextInt(10) == 0;
    }

    public static boolean isOverworld(class_1937 world) {
        return world.method_8597().comp_645();
    }

    public static boolean isStructureWithinRange(@Nullable class_3341 bb, class_2338 playerPos, int maxRange) {
        return bb != null && playerPos.method_10263() >= bb.method_35415() - maxRange && playerPos.method_10263() <= bb.method_35418() + maxRange && playerPos.method_10260() >= bb.method_35417() - maxRange && playerPos.method_10260() <= bb.method_35420() + maxRange;
    }

    public static boolean isStructureWithinRange(@Nullable IntBoundingBox bb, class_2338 playerPos, int maxRange) {
        return bb != null && playerPos.method_10263() >= bb.minX - maxRange && playerPos.method_10263() <= bb.maxX + maxRange && playerPos.method_10260() >= bb.minZ - maxRange && playerPos.method_10260() <= bb.maxZ + maxRange;
    }

    public static boolean areBoxesEqual(IntBoundingBox bb1, IntBoundingBox bb2) {
        return bb1.minX == bb2.minX && bb1.minY == bb2.minY && bb1.minZ == bb2.minZ && bb1.maxX == bb2.maxX && bb1.maxY == bb2.maxY && bb1.maxZ == bb2.maxZ;
    }

    public static void addAxolotlTooltip(class_1799 stack, List<class_2561> lines) {
        class_9279 entityData = (class_9279)stack.method_57353().method_57829(class_9334.field_49610);
        if (entityData != null) {
            class_2487 tag = entityData.method_57461();
            int variantId = tag.method_10550("Variant");
            class_5762.class_5767 variant = class_5762.class_5767.method_47928((int)variantId);
            String variantName = variant.method_33238();
            class_5250 labelText = class_2561.method_43471((String)"minihud.label.axolotl_tooltip.label");
            class_5250 valueText = class_2561.method_43469((String)"minihud.label.axolotl_tooltip.value", (Object[])new Object[]{variantName, variantId});
            if (variantId < AXOLOTL_COLORS.length) {
                valueText.method_10862(class_2583.field_24360.method_36139(AXOLOTL_COLORS[variantId]));
            }
            lines.add(Math.min(1, lines.size()), (class_2561)labelText.method_10852((class_2561)valueText));
        }
    }

    public static void addBeeTooltip(class_1799 stack, List<class_2561> lines) {
        List beeList = (List)stack.method_57353().method_57829(class_9334.field_49624);
        if (beeList != null && !beeList.isEmpty()) {
            int count = beeList.size();
            int babyCount = 0;
            for (class_4482.class_9309 beeOccupant : beeList) {
                class_9279 beeData = beeOccupant.comp_2431();
                class_2487 beeTag = beeData.method_57461();
                int beeTicks = beeOccupant.comp_2432();
                String beeName = "";
                int beeAge = -1;
                if (beeTag.method_10573("CustomName", 8)) {
                    beeName = beeTag.method_10558("CustomName");
                }
                if (beeTag.method_10573("Age", 3)) {
                    beeAge = beeTag.method_10550("Age");
                }
                if (beeAge + beeTicks < 0) {
                    ++babyCount;
                }
                if (beeName.isEmpty()) continue;
                class_5250 beeText = class_2561.class_2562.method_10877((String)beeName, (class_7225.class_7874)DataStorage.getInstance().getWorldRegistryManager());
                lines.add(Math.min(1, lines.size()), (class_2561)class_2561.method_43469((String)"minihud.label.bee_tooltip.name", (Object[])new Object[]{beeText}));
            }
            class_5250 text = babyCount > 0 ? class_2561.method_43469((String)"minihud.label.bee_tooltip.count_babies", (Object[])new Object[]{String.valueOf(count), String.valueOf(babyCount)}) : class_2561.method_43469((String)"minihud.label.bee_tooltip.count", (Object[])new Object[]{String.valueOf(count)});
            lines.add(Math.min(1, lines.size()), (class_2561)text);
        }
    }

    public static void addHoneyTooltip(class_1799 stack, List<class_2561> lines) {
        class_9275 blockItemState = (class_9275)stack.method_57353().method_57829(class_9334.field_49623);
        if (blockItemState != null && !blockItemState.method_57414()) {
            Integer honey = (Integer)blockItemState.method_57418((class_2769)class_2741.field_20432);
            String honeyLevel = "0";
            if (honey != null && honey >= 0 && honey <= 5) {
                honeyLevel = String.valueOf(honey);
            }
            lines.add(Math.min(1, lines.size()), (class_2561)class_2561.method_43469((String)"minihud.label.honey_info.level", (Object[])new Object[]{honeyLevel}));
        }
    }

    public static int getFurnaceXpAmount(class_2609 be) {
        Object2IntOpenHashMap<class_2960> recipes = ((IMixinAbstractFurnaceBlockEntity)be).minihud_getUsedRecipes();
        class_1937 world = be.method_10997();
        double xp = 0.0;
        for (Object2IntMap.Entry entry : recipes.object2IntEntrySet()) {
            class_1860 class_18602;
            Optional recipeOpt = world.method_8433().method_8130((class_2960)entry.getKey());
            if (!recipeOpt.isPresent() || !((class_18602 = ((class_8786)recipeOpt.get()).comp_1933()) instanceof class_1874)) continue;
            class_1874 recipe = (class_1874)class_18602;
            xp += (double)((float)entry.getIntValue() * recipe.method_8171());
        }
        return (int)xp;
    }
}

