/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.render.schematic.BufferAllocatorCache;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.BufferBuilderPatch;
import fi.dy.masa.litematica.render.schematic.ChunkCacheSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderLayers;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.util.OverlayType;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4696;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.class_827;
import net.minecraft.class_9799;
import net.minecraft.class_9801;

public class ChunkRendererSchematicVbo
implements AutoCloseable {
    protected static int schematicRenderChunksUpdated;
    protected volatile WorldSchematic world;
    protected final WorldRendererSchematic worldRenderer;
    protected final AtomicReference<Set<class_2586>> setBlockEntities = new AtomicReference(new HashSet());
    protected final class_2338.class_2339 position;
    protected final class_2338.class_2339 chunkRelativePos;
    protected final Map<class_1921, class_291> vertexBufferBlocks;
    protected final Map<OverlayRenderType, class_291> vertexBufferOverlay;
    protected final List<IntBoundingBox> boxes = new ArrayList<IntBoundingBox>();
    protected final EnumSet<OverlayRenderType> existingOverlays = EnumSet.noneOf(OverlayRenderType.class);
    private class_238 boundingBox;
    protected Color4f overlayColor;
    protected boolean hasOverlay = false;
    private boolean ignoreClientWorldFluids;
    protected ChunkCacheSchematic schematicWorldView;
    protected ChunkCacheSchematic clientWorldView;
    private final BufferBuilderCache builderCache;
    protected AtomicReference<ChunkRenderTaskSchematic> compileTask = new AtomicReference<Object>(null);
    protected AtomicReference<ChunkRenderDataSchematic> chunkRenderData = new AtomicReference<ChunkRenderDataSchematic>(ChunkRenderDataSchematic.EMPTY);
    private boolean needsUpdate;
    private boolean needsImmediateUpdate;

    protected ChunkRendererSchematicVbo(WorldSchematic world, WorldRendererSchematic worldRenderer) {
        this.world = world;
        this.worldRenderer = worldRenderer;
        this.vertexBufferBlocks = new IdentityHashMap<class_1921, class_291>();
        this.vertexBufferOverlay = new IdentityHashMap<OverlayRenderType, class_291>();
        this.position = new class_2338.class_2339();
        this.chunkRelativePos = new class_2338.class_2339();
        this.builderCache = new BufferBuilderCache();
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    public EnumSet<OverlayRenderType> getOverlayTypes() {
        return this.existingOverlays;
    }

    protected class_291 getBlocksVertexBufferByLayer(class_1921 layer) {
        return this.vertexBufferBlocks.computeIfAbsent(layer, l -> new class_291(class_291.class_8555.field_44793));
    }

    protected class_291 getOverlayVertexBuffer(OverlayRenderType type) {
        return this.vertexBufferOverlay.computeIfAbsent(type, l -> new class_291(class_291.class_8555.field_44793));
    }

    protected ChunkRenderDataSchematic getChunkRenderData() {
        return this.chunkRenderData.get();
    }

    protected BufferBuilderCache getBuilderCache() {
        return this.builderCache;
    }

    protected void setChunkRenderData(ChunkRenderDataSchematic data) {
        this.chunkRenderData.set(data);
    }

    public class_2338 getOrigin() {
        return this.position;
    }

    public class_238 getBoundingBox() {
        if (this.boundingBox == null) {
            int x = this.position.method_10263();
            int y = this.position.method_10264();
            int z = this.position.method_10260();
            this.boundingBox = new class_238((double)x, (double)y, (double)z, (double)(x + 16), (double)(y + this.world.method_31605()), (double)(z + 16));
        }
        return this.boundingBox;
    }

    protected void setPosition(int x, int y, int z) {
        if (x != this.position.method_10263() || y != this.position.method_10264() || z != this.position.method_10260()) {
            this.clear();
            this.boundingBox = null;
            this.position.method_10103(x, y, z);
        }
    }

    protected double getDistanceSq() {
        class_1297 entity = EntityUtils.getCameraEntity();
        double x = (double)this.position.method_10263() + 8.0 - entity.method_23317();
        double z = (double)this.position.method_10260() + 8.0 - entity.method_23321();
        return x * x + z * z;
    }

    protected void deleteGlResources() {
        this.clear();
        this.closeAllVertexBuffers();
    }

    private void closeAllVertexBuffers() {
        this.vertexBufferBlocks.values().forEach(class_291::close);
        this.vertexBufferOverlay.values().forEach(class_291::close);
        this.vertexBufferBlocks.clear();
        this.vertexBufferOverlay.clear();
    }

    protected void resortTransparency(ChunkRenderTaskSchematic task) {
        OverlayRenderType type;
        ChunkRenderDataSchematic data = task.getChunkRenderData();
        class_243 cameraPos = task.getCameraPosSupplier().get();
        class_1921 layerTranslucent = class_1921.method_23583();
        BufferAllocatorCache allocators = task.getAllocatorCache();
        float x = (float)cameraPos.field_1352 - (float)this.position.method_10263();
        float y = (float)cameraPos.field_1351 - (float)this.position.method_10264();
        float z = (float)cameraPos.field_1350 - (float)this.position.method_10260();
        if (!data.isBlockLayerEmpty(layerTranslucent)) {
            RenderSystem.setShader(class_757::method_34498);
            if (data.getBuiltBufferCache().hasBuiltBufferByLayer(layerTranslucent)) {
                try {
                    this.resortRenderBlocks(layerTranslucent, x, y, z, data, allocators);
                }
                catch (Exception e) {
                    Litematica.logger.error("resortTransparency() [VBO] caught exception for layer [{}] // {}", (Object)ChunkRenderLayers.getFriendlyName(layerTranslucent), (Object)e.toString());
                }
            }
        }
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_RESORTING.getBooleanValue() && !data.isOverlayTypeEmpty(type = OverlayRenderType.QUAD) && data.getBuiltBufferCache().hasBuiltBufferByType(type)) {
            try {
                this.resortRenderOverlay(type, x, y, z, data, allocators);
            }
            catch (Exception e) {
                Litematica.logger.error("resortTransparency() [VBO] caught exception for overlay type [{}] // {}", (Object)type.getDrawMode().name(), (Object)e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildChunk(ChunkRenderTaskSchematic task) {
        ChunkRenderDataSchematic data = new ChunkRenderDataSchematic();
        task.setChunkRenderData(data);
        this.builderCache.clearAll();
        HashSet<class_2586> tileEntities = new HashSet<class_2586>();
        class_2338.class_2339 posChunk = this.position;
        LayerRange range = DataManager.getRenderLayerRange();
        BufferAllocatorCache allocators = task.getAllocatorCache();
        this.existingOverlays.clear();
        this.hasOverlay = false;
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            int minX = posChunk.method_10263();
            int minY = posChunk.method_10264();
            int minZ = posChunk.method_10260();
            int maxX = minX + 15;
            int maxY = minY + this.world.method_31605();
            int maxZ = minZ + 15;
            if (!(this.boxes.isEmpty() || this.schematicWorldView.isEmpty() && this.clientWorldView.isEmpty() || !range.intersectsBox(minX, minY, minZ, maxX, maxY, maxZ))) {
                ++schematicRenderChunksUpdated;
                class_243 cameraPos = task.getCameraPosSupplier().get();
                float x = (float)cameraPos.field_1352 - (float)this.position.method_10263();
                float y = (float)cameraPos.field_1351 - (float)this.position.method_10264();
                float z = (float)cameraPos.field_1350 - (float)this.position.method_10260();
                HashSet<class_1921> usedLayers = new HashSet<class_1921>();
                class_4587 matrixStack = new class_4587();
                int bottomY = this.position.method_10264();
                for (IntBoundingBox box : this.boxes) {
                    if ((box = range.getClampedRenderBoundingBox(box)) == null) continue;
                    class_2338 posFrom = new class_2338(box.minX, box.minY, box.minZ);
                    class_2338 posTo = new class_2338(box.maxX, box.maxY, box.maxZ);
                    for (class_2338 posMutable : class_2338.class_2339.method_10097((class_2338)posFrom, (class_2338)posTo)) {
                        matrixStack.method_22903();
                        matrixStack.method_46416((float)(posMutable.method_10263() & 0xF), (float)(posMutable.method_10264() - bottomY), (float)(posMutable.method_10260() & 0xF));
                        this.renderBlocksAndOverlay(posMutable, data, allocators, tileEntities, usedLayers, matrixStack);
                        matrixStack.method_22909();
                    }
                }
                for (class_1921 layerTmp : ChunkRenderLayers.LAYERS) {
                    if (usedLayers.contains(layerTmp)) {
                        data.setBlockLayerUsed(layerTmp);
                    }
                    if (!data.isBlockLayerStarted(layerTmp)) continue;
                    try {
                        data.setBlockLayerUsed(layerTmp);
                        this.postRenderBlocks(layerTmp, x, y, z, data, allocators);
                    }
                    catch (Exception e) {
                        Litematica.logger.error("rebuildChunk() [VBO] failed to postRenderBlocks() for layer [{}] --> {}", (Object)ChunkRenderLayers.getFriendlyName(layerTmp), (Object)e.toString());
                    }
                }
                if (this.hasOverlay) {
                    for (OverlayRenderType type : this.existingOverlays) {
                        if (!data.isOverlayTypeStarted(type)) continue;
                        try {
                            data.setOverlayTypeUsed(type);
                            this.postRenderOverlay(type, x, y, z, data, allocators);
                        }
                        catch (Exception e) {
                            Litematica.logger.error("rebuildChunk() [VBO] failed to postRenderOverlay() for overlay type [{}] --> {}", (Object)type.getDrawMode().name(), (Object)e.toString());
                        }
                    }
                }
            }
        }
        Set removed = this.setBlockEntities.getAndSet(tileEntities);
        HashSet added = Sets.newHashSet(tileEntities);
        added.removeAll(removed);
        removed.removeAll(tileEntities);
        BufferBuilderCache bufferBuilderCache = this.builderCache;
        synchronized (bufferBuilderCache) {
            this.worldRenderer.updateBlockEntities(removed, added);
            this.builderCache.clearAll();
        }
        data.setTimeBuilt(this.world.method_8510());
    }

    protected void renderBlocksAndOverlay(class_2338 pos, @Nonnull ChunkRenderDataSchematic data, @Nonnull BufferAllocatorCache allocators, Set<class_2586> tileEntities, Set<class_1921> usedLayers, class_4587 matrixStack) {
        class_2680 stateSchematic = this.schematicWorldView.method_8320(pos);
        class_2680 stateClient = this.clientWorldView.method_8320(pos);
        boolean clientHasAir = stateClient.method_26215();
        boolean schematicHasAir = stateSchematic.method_26215();
        boolean missing = false;
        if (clientHasAir && schematicHasAir) {
            return;
        }
        this.overlayColor = null;
        if (clientHasAir || stateSchematic != stateClient && Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
            class_1921 layer;
            if (stateSchematic.method_31709()) {
                this.addBlockEntity(pos, data, tileEntities);
            }
            boolean translucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
            class_3610 fluidState = stateSchematic.method_26227();
            if (!fluidState.method_15769()) {
                layer = class_4696.method_23680((class_3610)fluidState);
                int offsetY = (pos.method_10264() >> 4 << 4) - this.position.method_10264();
                BufferBuilderPatch bufferSchematic = this.builderCache.getBufferByLayer(layer, allocators);
                if (!data.isBlockLayerStarted(layer) || bufferSchematic == null) {
                    data.setBlockLayerStarted(layer);
                    bufferSchematic = this.preRenderBlocks(layer, allocators);
                }
                bufferSchematic.setOffsetY(offsetY);
                this.worldRenderer.renderFluid(this.schematicWorldView, stateSchematic, fluidState, pos, bufferSchematic);
                usedLayers.add(layer);
                bufferSchematic.setOffsetY(0.0f);
            }
            if (stateSchematic.method_26217() != class_2464.field_11455) {
                layer = translucent ? class_1921.method_23583() : class_4696.method_23679((class_2680)stateSchematic);
                BufferBuilderPatch bufferSchematic = this.builderCache.getBufferByLayer(layer, allocators);
                if (!data.isBlockLayerStarted(layer) || bufferSchematic == null) {
                    data.setBlockLayerStarted(layer);
                    bufferSchematic = this.preRenderBlocks(layer, allocators);
                }
                if (this.worldRenderer.renderBlock(this.schematicWorldView, stateSchematic, pos, matrixStack, bufferSchematic)) {
                    usedLayers.add(layer);
                }
                if (clientHasAir) {
                    missing = true;
                }
            }
        }
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue()) {
            OverlayType type = this.getOverlayType(stateSchematic, stateClient);
            this.overlayColor = this.getOverlayColor(type);
            if (this.overlayColor != null) {
                this.renderOverlay(type, pos, stateSchematic, missing, data, allocators);
            }
        }
    }

    protected void renderOverlay(OverlayType type, class_2338 pos, class_2680 stateSchematic, boolean missing, @Nonnull ChunkRenderDataSchematic data, @Nonnull BufferAllocatorCache allocators) {
        class_1087 bakedModel3;
        OverlayRenderType overlayType;
        RenderSystem.setShader(class_757::method_34540);
        class_2338.class_2339 relPos = this.getChunkRelativePosition(pos);
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_SIDES.getBooleanValue()) {
            overlayType = OverlayRenderType.QUAD;
            BufferBuilderPatch bufferOverlayQuads = this.builderCache.getBufferByOverlay(overlayType, allocators);
            if (!data.isOverlayTypeStarted(overlayType) || bufferOverlayQuads == null) {
                data.setOverlayTypeStarted(overlayType);
                bufferOverlayQuads = this.preRenderOverlay(overlayType, allocators);
            }
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                class_2338.class_2339 posMutable = new class_2338.class_2339();
                for (int i = 0; i < 6; ++i) {
                    class_2350 side = PositionUtils.ALL_DIRECTIONS[i];
                    posMutable.method_10103(pos.method_10263() + side.method_10148(), pos.method_10264() + side.method_10164(), pos.method_10260() + side.method_10165());
                    class_2680 adjStateSchematic = this.schematicWorldView.method_8320((class_2338)posMutable);
                    class_2680 adjStateClient = this.clientWorldView.method_8320((class_2338)posMutable);
                    OverlayType typeAdj = this.getOverlayType(adjStateSchematic, adjStateClient);
                    if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                        class_1087 bakedModel2 = this.worldRenderer.getModelForState(stateSchematic);
                        if (type.getRenderPriority() <= typeAdj.getRenderPriority() && class_2248.method_9501((class_265)stateSchematic.method_26220((class_1922)this.schematicWorldView, pos), (class_2350)side)) continue;
                        RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel2, stateSchematic, (class_2338)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                        continue;
                    }
                    if (type.getRenderPriority() <= typeAdj.getRenderPriority()) continue;
                    RenderUtils.drawBlockBoxSideBatchedQuads((class_2338)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                bakedModel3 = this.worldRenderer.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel3, stateSchematic, (class_2338)relPos, this.overlayColor, 0.0, bufferOverlayQuads);
            } else {
                try {
                    fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxSidesBatchedQuads((class_2338)relPos, (Color4f)this.overlayColor, (double)0.0, (class_287)bufferOverlayQuads);
                }
                catch (Exception bakedModel3) {
                    // empty catch block
                }
            }
        }
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_OUTLINES.getBooleanValue()) {
            overlayType = OverlayRenderType.OUTLINE;
            BufferBuilderPatch bufferOverlayOutlines = this.builderCache.getBufferByOverlay(overlayType, allocators);
            if (!data.isOverlayTypeStarted(overlayType) || bufferOverlayOutlines == null) {
                data.setOverlayTypeStarted(overlayType);
                bufferOverlayOutlines = this.preRenderOverlay(overlayType, allocators);
            }
            this.overlayColor = new Color4f(this.overlayColor.r, this.overlayColor.g, this.overlayColor.b, 1.0f);
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                OverlayType[][][] adjTypes = new OverlayType[3][3][3];
                class_2338.class_2339 posMutable = new class_2338.class_2339();
                for (int y = 0; y <= 2; ++y) {
                    for (int z = 0; z <= 2; ++z) {
                        for (int x = 0; x <= 2; ++x) {
                            if (x != 1 || y != 1 || z != 1) {
                                posMutable.method_10103(pos.method_10263() + x - 1, pos.method_10264() + y - 1, pos.method_10260() + z - 1);
                                class_2680 adjStateSchematic = this.schematicWorldView.method_8320((class_2338)posMutable);
                                class_2680 adjStateClient = this.clientWorldView.method_8320((class_2338)posMutable);
                                adjTypes[x][y][z] = this.getOverlayType(adjStateSchematic, adjStateClient);
                                continue;
                            }
                            adjTypes[x][y][z] = type;
                        }
                    }
                }
                if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                    class_1087 bakedModel4 = this.worldRenderer.getModelForState(stateSchematic);
                    if (stateSchematic.method_26225()) {
                        this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                    } else {
                        RenderUtils.drawBlockModelOutlinesBatched(bakedModel4, stateSchematic, (class_2338)relPos, this.overlayColor, 0.0, bufferOverlayOutlines);
                    }
                } else {
                    this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                bakedModel3 = this.worldRenderer.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelOutlinesBatched(bakedModel3, stateSchematic, (class_2338)relPos, this.overlayColor, 0.0, bufferOverlayOutlines);
            } else {
                try {
                    fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((class_2338)relPos, (Color4f)this.overlayColor, (double)0.0, (class_287)bufferOverlayOutlines);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected class_2338.class_2339 getChunkRelativePosition(class_2338 pos) {
        return this.chunkRelativePos.method_10103(pos.method_10263() & 0xF, pos.method_10264() - this.position.method_10264(), pos.method_10260() & 0xF);
    }

    protected void renderOverlayReducedEdges(class_2338 pos, OverlayType[][][] adjTypes, OverlayType typeSelf, class_287 bufferOverlayOutlines) {
        OverlayType[] neighborTypes = new OverlayType[4];
        class_2382[] neighborPositions = new class_2382[4];
        int lines = 0;
        for (class_2350.class_2351 axis : fi.dy.masa.litematica.util.PositionUtils.AXES_ALL) {
            for (int corner = 0; corner < 4; ++corner) {
                class_2382[] offsets = fi.dy.masa.litematica.util.PositionUtils.getEdgeNeighborOffsets(axis, corner);
                int index = -1;
                boolean hasCurrent = false;
                for (int i = 0; i < 4; ++i) {
                    class_2382 offset = offsets[i];
                    OverlayType type = adjTypes[offset.method_10263() + 1][offset.method_10264() + 1][offset.method_10260() + 1];
                    if (type == OverlayType.NONE || index != -1 && type.getRenderPriority() < neighborTypes[index - 1].getRenderPriority()) continue;
                    if (index < 0 || type.getRenderPriority() > neighborTypes[index - 1].getRenderPriority()) {
                        index = 0;
                    }
                    neighborPositions[index] = new class_2382(pos.method_10263() + offset.method_10263(), pos.method_10264() + offset.method_10264(), pos.method_10260() + offset.method_10260());
                    neighborTypes[index] = type;
                    hasCurrent |= i == 0;
                    ++index;
                }
                if (index <= 0 || !hasCurrent) continue;
                class_2382 posTmp = new class_2382(pos.method_10263(), pos.method_10264(), pos.method_10260());
                int ind = -1;
                for (int i = 0; i < index; ++i) {
                    class_2382 tmp = neighborPositions[i];
                    if (tmp.method_10263() > posTmp.method_10263() || tmp.method_10264() > posTmp.method_10264() || tmp.method_10260() > posTmp.method_10260()) continue;
                    posTmp = tmp;
                    ind = i;
                }
                if (posTmp.method_10263() != pos.method_10263() || posTmp.method_10264() != pos.method_10264() || posTmp.method_10260() != pos.method_10260()) continue;
                try {
                    RenderUtils.drawBlockBoxEdgeBatchedLines((class_2338)this.getChunkRelativePosition(pos), axis, corner, this.overlayColor, bufferOverlayOutlines);
                }
                catch (IllegalStateException err) {
                    return;
                }
                ++lines;
            }
        }
    }

    protected OverlayType getOverlayType(class_2680 stateSchematic, class_2680 stateClient) {
        if (stateSchematic == stateClient) {
            return OverlayType.NONE;
        }
        boolean clientHasAir = stateClient.method_26215();
        boolean schematicHasAir = stateSchematic.method_26215();
        if (schematicHasAir) {
            return clientHasAir || this.ignoreClientWorldFluids && stateClient.method_51176() ? OverlayType.NONE : OverlayType.EXTRA;
        }
        if (clientHasAir || this.ignoreClientWorldFluids && stateClient.method_51176()) {
            return OverlayType.MISSING;
        }
        if (stateSchematic.method_26204() != stateClient.method_26204()) {
            return OverlayType.WRONG_BLOCK;
        }
        return OverlayType.WRONG_STATE;
    }

    @Nullable
    protected Color4f getOverlayColor(OverlayType overlayType) {
        Color4f overlayColor = null;
        switch (overlayType) {
            case MISSING: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_MISSING.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_MISSING.getColor();
                break;
            }
            case EXTRA: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_EXTRA.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_EXTRA.getColor();
                break;
            }
            case WRONG_BLOCK: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_BLOCK.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_BLOCK.getColor();
                break;
            }
            case WRONG_STATE: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_STATE.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_STATE.getColor();
                break;
            }
        }
        return overlayColor;
    }

    private void addBlockEntity(class_2338 pos, ChunkRenderDataSchematic chunkRenderData, Set<class_2586> blockEntities) {
        class_827 tesr;
        class_2586 te = this.schematicWorldView.getBlockEntity(pos, class_2818.class_2819.field_12859);
        if (te != null && (tesr = class_310.method_1551().method_31975().method_3550(te)) != null) {
            chunkRenderData.addBlockEntity(te);
            if (tesr.method_3563(te)) {
                blockEntities.add(te);
            }
        }
    }

    private BufferBuilderPatch preRenderBlocks(class_1921 layer, @Nonnull BufferAllocatorCache allocators) {
        return this.builderCache.getBufferByLayer(layer, allocators);
    }

    private BufferBuilderPatch preRenderOverlay(OverlayRenderType type, @Nonnull BufferAllocatorCache allocators) {
        this.existingOverlays.add(type);
        this.hasOverlay = true;
        RenderSystem.setShader(class_757::method_34540);
        return this.builderCache.getBufferByOverlay(type, allocators);
    }

    protected void uploadBuiltBuffer(@Nonnull class_9801 builtBuffer, @Nonnull class_291 vertexBuffer) {
        if (vertexBuffer.method_43444()) {
            Litematica.logger.error("uploadBuiltBuffer() [VBO] - Error, vertexBuffer is closed/Null");
            builtBuffer.close();
            return;
        }
        vertexBuffer.method_1353();
        vertexBuffer.method_1352(builtBuffer);
        class_291.method_1354();
    }

    private void postRenderBlocks(class_1921 layer, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) throws RuntimeException {
        if (!chunkRenderData.isBlockLayerEmpty(layer)) {
            class_9801 built;
            if (chunkRenderData.getBuiltBufferCache().hasBuiltBufferByLayer(layer)) {
                chunkRenderData.getBuiltBufferCache().getBuiltBufferByLayer(layer).close();
            }
            if (this.builderCache.hasBufferByLayer(layer)) {
                BufferBuilderPatch builder = this.builderCache.getBufferByLayer(layer, allocators);
                built = builder.method_60794();
                if (built == null) {
                    throw new RuntimeException("failed to build BuiltBuffer");
                }
            } else {
                throw new RuntimeException("BufferBuilder has not been initialized");
            }
            chunkRenderData.getBuiltBufferCache().storeBuiltBufferByLayer(layer, built);
            if (layer == class_1921.method_23583()) {
                try {
                    this.resortRenderBlocks(layer, x, y, z, chunkRenderData, allocators);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
            }
        }
    }

    private void postRenderOverlay(OverlayRenderType type, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) throws RuntimeException {
        RenderSystem.applyModelViewMatrix();
        if (!chunkRenderData.isOverlayTypeEmpty(type)) {
            class_9801 built;
            if (chunkRenderData.getBuiltBufferCache().hasBuiltBufferByType(type)) {
                chunkRenderData.getBuiltBufferCache().getBuiltBufferByType(type).close();
            }
            if (this.builderCache.hasBufferByOverlay(type)) {
                BufferBuilderPatch builder = this.builderCache.getBufferByOverlay(type, allocators);
                built = builder.method_60794();
                if (built == null) {
                    throw new RuntimeException("failed to build BuiltBuffer");
                }
            } else {
                throw new RuntimeException("BufferBuilder has not been initialized");
            }
            chunkRenderData.getBuiltBufferCache().storeBuiltBufferByType(type, built);
            if (type.isTranslucent() && Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_RESORTING.getBooleanValue()) {
                try {
                    this.resortRenderOverlay(type, x, y, z, chunkRenderData, allocators);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
            }
        }
    }

    protected class_8251 createVertexSorter(float x, float y, float z) {
        return class_8251.method_49906((float)x, (float)y, (float)z);
    }

    protected class_8251 createVertexSorter(class_243 pos) {
        return class_8251.method_49906((float)((float)pos.method_10216()), (float)((float)pos.method_10214()), (float)((float)pos.method_10215()));
    }

    protected class_8251 createVertexSorter(class_243 pos, class_2338 origin) {
        return class_8251.method_49906((float)((float)(pos.field_1352 - (double)origin.method_10263())), (float)((float)(pos.field_1351 - (double)origin.method_10264())), (float)((float)(pos.field_1350 - (double)origin.method_10260())));
    }

    protected class_8251 createVertexSorter(class_4184 camera) {
        class_243 vec3d = camera.method_19326();
        return this.createVertexSorter(vec3d, this.getOrigin());
    }

    protected void uploadSortingState(@Nonnull class_9799.class_9800 result, @Nonnull class_291 vertexBuffer) {
        if (vertexBuffer.method_43444()) {
            Litematica.logger.error("uploadSortingState() [VBO] - Error, vertexBuffer is closed/Null");
            result.close();
            return;
        }
        vertexBuffer.method_1353();
        vertexBuffer.method_60829(result);
        class_291.method_1354();
    }

    private void resortRenderBlocks(class_1921 layer, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) throws InterruptedException {
        if (!chunkRenderData.isBlockLayerEmpty(layer)) {
            class_9799 allocator = allocators.getBufferByLayer(layer);
            if (allocator == null) {
                throw new InterruptedException("Buffers are invalid");
            }
            if (!chunkRenderData.getBuiltBufferCache().hasBuiltBufferByLayer(layer)) {
                throw new InterruptedException("Buffers are invalid");
            }
            class_9801 built = chunkRenderData.getBuiltBufferCache().getBuiltBufferByLayer(layer);
            if (built == null) {
                throw new InterruptedException("Buffers are invalid");
            }
            if (layer == class_1921.method_23583()) {
                class_9801.class_9802 sortingData;
                class_8251 sorter = class_8251.method_49906((float)x, (float)y, (float)z);
                if (!chunkRenderData.hasTransparentSortingData()) {
                    sortingData = built.method_60819(allocator, sorter);
                    if (sortingData == null) {
                        throw new InterruptedException("Sort State failure");
                    }
                    chunkRenderData.setTransparentSortingData(sortingData);
                } else {
                    sortingData = chunkRenderData.getTransparentSortingData();
                }
                if (sortingData == null) {
                    throw new InterruptedException("Sorting Data failure");
                }
            } else {
                throw new InterruptedException("layer is not translucent");
            }
        }
    }

    private void resortRenderOverlay(OverlayRenderType type, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) throws InterruptedException {
        RenderSystem.applyModelViewMatrix();
        if (!chunkRenderData.isOverlayTypeEmpty(type)) {
            class_9799 allocator = allocators.getBufferByOverlay(type);
            if (allocator == null) {
                throw new InterruptedException("Buffers are invalid");
            }
            if (!chunkRenderData.getBuiltBufferCache().hasBuiltBufferByType(type)) {
                throw new InterruptedException("Buffers are invalid");
            }
            class_9801 built = chunkRenderData.getBuiltBufferCache().getBuiltBufferByType(type);
            if (built == null) {
                throw new InterruptedException("Buffers are invalid");
            }
            if (type.isTranslucent() && Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_RESORTING.getBooleanValue()) {
                class_9801.class_9802 sortingData;
                class_8251 sorter = class_8251.method_49906((float)x, (float)y, (float)z);
                if (!chunkRenderData.hasTransparentSortingDataForOverlay(type)) {
                    sortingData = built.method_60819(allocator, sorter);
                    if (sortingData == null) {
                        throw new InterruptedException("Sort State failure");
                    }
                    chunkRenderData.setTransparentSortingDataForOverlay(type, sortingData);
                } else {
                    sortingData = chunkRenderData.getTransparentSortingDataForOverlay(type);
                }
                if (sortingData == null) {
                    throw new InterruptedException("Sorting Data failure");
                }
            } else {
                throw new InterruptedException("layer is not translucent");
            }
        }
    }

    protected ChunkRenderTaskSchematic makeCompileTaskChunkSchematic(Supplier<class_243> cameraPosSupplier) {
        ChunkRenderTaskSchematic generator = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.REBUILD_CHUNK, cameraPosSupplier, this.getDistanceSq());
        this.finishCompileTask(generator);
        this.rebuildWorldView();
        return generator;
    }

    @Nullable
    protected ChunkRenderTaskSchematic makeCompileTaskTransparencySchematic(Supplier<class_243> cameraPosSupplier) {
        if (this.compileTask.get().getStatus() == ChunkRenderTaskSchematic.Status.PENDING) {
            return null;
        }
        ChunkRenderTaskSchematic newTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY, cameraPosSupplier, this.getDistanceSq());
        newTask.setChunkRenderData(this.chunkRenderData.get());
        this.finishCompileTask(newTask);
        return newTask;
    }

    protected void finishCompileTask(@Nullable ChunkRenderTaskSchematic newTask) {
        ChunkRenderTaskSchematic oldtask = this.compileTask.getAndSet(newTask);
        if (oldtask != null) {
            oldtask.finish();
        }
    }

    protected void clear() {
        try {
            this.finishCompileTask(null);
        }
        finally {
            this.builderCache.clearAll();
            this.chunkRenderData.get().clearAll();
            this.chunkRenderData.set(ChunkRenderDataSchematic.EMPTY);
            this.existingOverlays.clear();
            this.hasOverlay = false;
        }
    }

    protected void setNeedsUpdate(boolean immediate) {
        if (this.needsUpdate) {
            immediate |= this.needsImmediateUpdate;
        }
        this.needsUpdate = true;
        this.needsImmediateUpdate = immediate;
    }

    protected void clearNeedsUpdate() {
        this.needsUpdate = false;
        this.needsImmediateUpdate = false;
    }

    protected boolean needsUpdate() {
        return this.needsUpdate;
    }

    protected boolean needsImmediateUpdate() {
        return this.needsUpdate && this.needsImmediateUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildWorldView() {
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            this.ignoreClientWorldFluids = Configs.Visuals.IGNORE_EXISTING_FLUIDS.getBooleanValue();
            class_638 worldClient = class_310.method_1551().field_1687;
            assert (worldClient != null);
            this.schematicWorldView = new ChunkCacheSchematic(this.world, worldClient, (class_2338)this.position, 2);
            this.clientWorldView = new ChunkCacheSchematic((class_1937)worldClient, worldClient, (class_2338)this.position, 2);
            this.boxes.clear();
            int chunkX = this.position.method_10263() / 16;
            int chunkZ = this.position.method_10260() / 16;
            for (SchematicPlacementManager.PlacementPart part : DataManager.getSchematicPlacementManager().getPlacementPartsInChunk(chunkX, chunkZ)) {
                this.boxes.add(part.bb);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.deleteGlResources();
    }

    public static enum OverlayRenderType {
        OUTLINE(class_293.class_5596.field_29344, 1536, class_290.field_1576, false, false),
        QUAD(class_293.class_5596.field_27382, 1536, class_290.field_1576, false, true);

        private final class_293.class_5596 drawMode;
        private final class_293 vertexFormat;
        private final int bufferSize;
        private final boolean hasCrumbling;
        private final boolean translucent;

        private OverlayRenderType(class_293.class_5596 drawMode, int bufferSize, class_293 format, boolean crumbling, boolean translucent) {
            this.drawMode = drawMode;
            this.bufferSize = bufferSize;
            this.vertexFormat = format;
            this.hasCrumbling = crumbling;
            this.translucent = translucent;
        }

        public class_293.class_5596 getDrawMode() {
            return this.drawMode;
        }

        public int getExpectedBufferSize() {
            return this.bufferSize;
        }

        public class_293 getVertexFormat() {
            return this.vertexFormat;
        }

        public boolean hasCrumbling() {
            return this.hasCrumbling;
        }

        public boolean isTranslucent() {
            return this.translucent;
        }
    }
}

