/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.render.schematic.BufferAllocatorCache;
import fi.dy.masa.litematica.render.schematic.BufferBuilderPatch;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.class_1921;
import net.minecraft.class_9801;

public class BufferBuilderCache
implements AutoCloseable {
    private final ConcurrentHashMap<class_1921, BufferBuilderPatch> blockBufferBuilders = new ConcurrentHashMap();
    private final ConcurrentHashMap<ChunkRendererSchematicVbo.OverlayRenderType, BufferBuilderPatch> overlayBufferBuilders = new ConcurrentHashMap();

    protected BufferBuilderCache() {
    }

    protected boolean hasBufferByLayer(class_1921 layer) {
        return this.blockBufferBuilders.containsKey(layer);
    }

    protected boolean hasBufferByOverlay(ChunkRendererSchematicVbo.OverlayRenderType type) {
        return this.overlayBufferBuilders.containsKey((Object)type);
    }

    protected BufferBuilderPatch getBufferByLayer(class_1921 layer, @Nonnull BufferAllocatorCache allocators) {
        return this.blockBufferBuilders.computeIfAbsent(layer, key -> new BufferBuilderPatch(allocators.getBufferByLayer((class_1921)key), key.method_23033(), key.method_23031()));
    }

    protected BufferBuilderPatch getBufferByOverlay(ChunkRendererSchematicVbo.OverlayRenderType type, @Nonnull BufferAllocatorCache allocators) {
        return this.overlayBufferBuilders.computeIfAbsent(type, key -> new BufferBuilderPatch(allocators.getBufferByOverlay((ChunkRendererSchematicVbo.OverlayRenderType)((Object)key)), key.getDrawMode(), key.getVertexFormat()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAll() {
        ArrayList<BufferBuilderPatch> buffers;
        Object object = this.blockBufferBuilders;
        synchronized (object) {
            buffers = new ArrayList<BufferBuilderPatch>(this.blockBufferBuilders.values());
            this.blockBufferBuilders.clear();
        }
        object = this.overlayBufferBuilders;
        synchronized (object) {
            buffers.addAll(this.overlayBufferBuilders.values());
            this.overlayBufferBuilders.clear();
        }
        for (BufferBuilderPatch buffer : buffers) {
            try {
                class_9801 built = buffer.method_60794();
                if (built == null) continue;
                built.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void close() throws Exception {
        this.clearAll();
    }
}

