/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.render.schematic.ChunkRenderLayers;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_9799;

@Environment(value=EnvType.CLIENT)
public class BufferAllocatorCache
implements AutoCloseable {
    protected static final List<class_1921> LAYERS = ChunkRenderLayers.LAYERS;
    protected static final List<ChunkRendererSchematicVbo.OverlayRenderType> TYPES = ChunkRenderLayers.TYPES;
    protected static final int EXPECTED_TOTAL_SIZE = LAYERS.stream().mapToInt(class_1921::method_22722).sum() + TYPES.stream().mapToInt(ChunkRendererSchematicVbo.OverlayRenderType::getExpectedBufferSize).sum();
    private final Map<class_1921, class_9799> layerCache = new HashMap<class_1921, class_9799>();
    private final Map<ChunkRendererSchematicVbo.OverlayRenderType, class_9799> overlayCache = new HashMap<ChunkRendererSchematicVbo.OverlayRenderType, class_9799>();

    protected BufferAllocatorCache() {
    }

    protected boolean hasBufferByLayer(class_1921 layer) {
        return this.layerCache.containsKey(layer);
    }

    protected boolean hasBufferByOverlay(ChunkRendererSchematicVbo.OverlayRenderType type) {
        return this.overlayCache.containsKey((Object)type);
    }

    protected class_9799 getBufferByLayer(class_1921 layer) {
        if (!this.layerCache.containsKey(layer)) {
            this.layerCache.put(layer, new class_9799(layer.method_22722()));
        }
        return this.layerCache.get(layer);
    }

    protected class_9799 getBufferByOverlay(ChunkRendererSchematicVbo.OverlayRenderType type) {
        if (!this.overlayCache.containsKey((Object)type)) {
            this.overlayCache.put(type, new class_9799(type.getExpectedBufferSize()));
        }
        return this.overlayCache.get((Object)type);
    }

    protected void closeByLayer(class_1921 layer) {
        try {
            if (this.layerCache.containsKey(layer)) {
                this.layerCache.get(layer).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.layerCache.remove(layer).close();
    }

    protected void closeByType(ChunkRendererSchematicVbo.OverlayRenderType type) {
        try {
            if (this.overlayCache.containsKey((Object)type)) {
                this.overlayCache.get((Object)type).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.overlayCache.remove((Object)type).close();
    }

    protected void resetAll() {
        try {
            this.layerCache.values().forEach(class_9799::method_60811);
            this.overlayCache.values().forEach(class_9799::method_60811);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void clearAll() {
        try {
            this.layerCache.values().forEach(class_9799::method_60809);
            this.overlayCache.values().forEach(class_9799::method_60809);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void closeAll() {
        try {
            this.layerCache.values().forEach(class_9799::close);
            this.overlayCache.values().forEach(class_9799::close);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.layerCache.clear();
        this.overlayCache.clear();
    }

    @Override
    public void close() {
        this.closeAll();
    }
}

