/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads_common_fabric.util;

import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.justmobheads_common_fabric.util.HeadData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Util {
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "justmobheads";
    private static final File dir = new File(dirpath);
    private static final File file = new File(dirpath + File.separator + "headchances.txt");

    public static boolean generateChanceConfig(Map<String, Double> defaultchances) throws IOException {
        HeadData.headChances = new HashMap<String, Double>();
        if (!dir.isDirectory() || !file.isFile()) {
            if (!dir.mkdirs()) {
                return false;
            }
        } else {
            String[] cspl;
            String content = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "headchances.txt", new String[0])));
            for (String line : cspl = content.replaceAll("\n", "").split(",")) {
                double chancevalue;
                String[] linespl = line.replace("\"", "").replaceAll(" ", "").trim().split(":");
                if (linespl.length < 2) continue;
                String mobname = linespl[0];
                try {
                    chancevalue = Double.parseDouble(linespl[1]);
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                HeadData.headChances.put(mobname, chancevalue);
            }
            ArrayList<String> appendkeys = new ArrayList<String>();
            ArrayList<String> defaultkeys = new ArrayList<String>(defaultchances.keySet());
            Collections.sort(defaultkeys);
            for (String mobname : defaultkeys) {
                if (HeadData.headChances.containsKey(mobname)) continue;
                appendkeys.add(mobname);
            }
            if (appendkeys.size() > 0) {
                PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(dirpath + File.separator + "headchances.txt", true)));
                Collections.sort(appendkeys);
                for (String mobname : appendkeys) {
                    Double chancevalue = defaultchances.get(mobname);
                    writer.println("\"" + mobname + "\" : " + chancevalue + ",");
                    HeadData.headChances.put(mobname, chancevalue);
                }
                writer.close();
            }
            return true;
        }
        PrintWriter writer = new PrintWriter(dirpath + File.separator + "headchances.txt", StandardCharsets.UTF_8);
        if (writer != null) {
            ArrayList<String> defaultkeys = new ArrayList<String>(defaultchances.keySet());
            Collections.sort(defaultkeys);
            for (String mobname : defaultkeys) {
                Double chancevalue = defaultchances.get(mobname);
                writer.println("\"" + mobname + "\" : " + chancevalue + ",");
                HeadData.headChances.put(mobname, chancevalue);
            }
            writer.close();
        }
        return false;
    }
}

