/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.JourneymapClient;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.nbt.waypoint.WaypointDAO;
import journeymap.common.waypoint.WaypointEventManager;
import journeymap.common.waypoint.WaypointImpl;

@ParametersAreNonnullByDefault
public class WaypointStore {
    private static WaypointStore INSTANCE;
    private final Map<String, ClientWaypointImpl> waypointMap = new LinkedHashMap<String, ClientWaypointImpl>();
    private final Set<String> dimensions = new HashSet<String>();
    private WaypointDAO dao;

    public static WaypointStore getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WaypointStore();
        }
        return INSTANCE;
    }

    public List<ClientWaypointImpl> getAll() {
        return this.waypointMap.values().stream().toList();
    }

    public void save(ClientWaypointImpl waypoint, boolean isNew) {
        this.waypointMap.put(waypoint.getGuid(), waypoint);
        if (isNew) {
            WaypointEventManager.createWaypointEvent(waypoint);
        } else {
            WaypointEventManager.updateWaypointEvent(waypoint);
        }
        if (waypoint.isPersistent()) {
            this.dao.addWaypoint(waypoint);
        }
        waypoint.setDirty(false);
        this.dao.save(false);
    }

    public void bulkSave() {
        for (ClientWaypointImpl waypoint : this.waypointMap.values()) {
            WaypointEventManager.updateWaypointEvent(waypoint);
            waypoint.setDirty(false);
            if (!waypoint.isPersistent()) continue;
            this.dao.addWaypoint(waypoint);
        }
        this.dao.save(false);
    }

    public ClientWaypointImpl get(String id) {
        return this.waypointMap.get(id);
    }

    public void remove(ClientWaypointImpl waypoint, boolean fireEvent) {
        this.waypointMap.remove(waypoint.getGuid());
        if (waypoint.isPersistent()) {
            if (fireEvent) {
                WaypointEventManager.deleteWaypointEvent(waypoint);
            }
            this.dao.deleteWaypoint(waypoint);
            this.dao.save(false);
        }
    }

    public void reset(WaypointDAO dao) {
        this.dao = dao;
        this.waypointMap.clear();
        this.dimensions.clear();
        if (JourneymapClient.getInstance().getWaypointProperties().managerEnabled.get().booleanValue()) {
            this.load();
        }
    }

    private void load() {
        Map<String, WaypointImpl> waypoints = this.dao.getWaypoints();
        for (WaypointImpl waypoint : waypoints.values()) {
            this.waypointMap.put(waypoint.getGuid(), (ClientWaypointImpl)waypoint);
            WaypointEventManager.readWaypointEvent(waypoint);
            this.dimensions.addAll(waypoint.getDimensions());
        }
        this.bulkSave();
    }

    public List<String> getLoadedDimensions() {
        return new ArrayList<String>(this.dimensions);
    }
}

