/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import com.mojang.authlib.GameProfile;
import journeymap.client.Constants;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.network.model.Location;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.PropertiesManager;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class JourneyMapTeleport {
    private static final JourneyMapTeleport INSTANCE = new JourneyMapTeleport();

    private JourneyMapTeleport() {
    }

    public static JourneyMapTeleport instance() {
        return INSTANCE;
    }

    public boolean attemptTeleport(class_1297 entity, Location location) {
        MinecraftServer mcServer = Journeymap.getInstance().getLoaderHooks().getServer();
        boolean creative = false;
        boolean cheatMode = false;
        if (entity == null) {
            Journeymap.getLogger().error("Attempted to teleport null entity.");
            return false;
        }
        if (entity instanceof class_3222) {
            creative = ((class_3222)entity).method_31549().field_7477;
            cheatMode = mcServer.method_3760().method_14569(new GameProfile(entity.method_5667(), entity.method_5477().getString()));
            if (mcServer == null) {
                entity.method_43496((class_2561)Constants.getStringTextComponent("Cannot Find World"));
                return false;
            }
            if (this.isTeleportAvailable(entity, location) || creative || cheatMode || Journeymap.getInstance().getLoaderHooks().isOp((class_1657)((class_3222)entity))) {
                if (!entity.method_5805()) {
                    entity.method_43496((class_2561)Constants.getStringTextComponent("Cannot teleport when dead."));
                    return false;
                }
                class_3218 destinationWorld = mcServer.method_3847(DimensionHelper.getWorldKeyForName(location.getDim()));
                if (destinationWorld == null) {
                    for (class_3218 world : mcServer.method_3738()) {
                        if (!location.getDim().equalsIgnoreCase(DimensionHelper.getDimName((class_1937)world)) && !location.getDim().equalsIgnoreCase(DimensionHelper.getDimKeyName((class_5321<class_1937>)world.method_27983()))) continue;
                        destinationWorld = world;
                        break;
                    }
                }
                if (destinationWorld == null) {
                    entity.method_43496((class_2561)Constants.getStringTextComponent("Could not get world for Dimension " + location.getDim()));
                    return false;
                }
                return this.teleportEntity(destinationWorld, entity, location);
            }
            entity.method_43496((class_2561)Constants.getStringTextComponent("Server has disabled JourneyMap teleport usage for your current or destination dimension."));
            return false;
        }
        return false;
    }

    private boolean isTeleportAvailable(class_1297 entity, Location location) {
        DimensionProperties destinationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getWorldKeyForName(location.getDim()));
        DimensionProperties entityLocationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension(entity));
        return this.canDimTeleport(destinationProperty) && this.canDimTeleport(entityLocationProperty);
    }

    private boolean canDimTeleport(DimensionProperties properties) {
        if (properties.enabled.get().booleanValue()) {
            return properties.teleportEnabled.get();
        }
        return PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get();
    }

    private boolean teleportEntity(class_3218 destinationWorld, class_1297 player, Location location) {
        boolean changedWorld;
        class_3218 startWorld = (class_3218)player.method_5770();
        boolean bl = changedWorld = startWorld != destinationWorld;
        if (player instanceof class_3222) {
            boolean crossDimTpAllow;
            class_3222 serverPlayer = (class_3222)player;
            boolean bl2 = crossDimTpAllow = PropertiesManager.getInstance().getGlobalProperties().crossDimTeleport.get() != false || Journeymap.getInstance().getLoaderHooks().isOp((class_1657)((class_3222)player));
            if (changedWorld) {
                if (crossDimTpAllow) {
                    serverPlayer.method_14251(destinationWorld, location.getX() + 0.5, location.getY() + 0.5, location.getZ() + 0.5, player.method_36454(), player.method_36455());
                } else {
                    serverPlayer.method_43496((class_2561)Constants.getStringTextComponent("Server disabled cross dimension teleport."));
                }
            } else {
                serverPlayer.method_5859(location.getX(), location.getY(), location.getZ());
            }
            if (!CommonConstants.debugOverride((class_1297)serverPlayer)) {
                Journeymap.getLogger().info("{} teleported to {} {} {} {}", (Object)serverPlayer.method_5477().getString(), (Object)location.getX(), (Object)location.getY(), (Object)location.getZ(), (Object)location.getDim());
            }
        }
        return false;
    }
}

