/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.io.ThemeLoader;
import journeymap.client.log.ChatLog;
import journeymap.client.log.JMLogger;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.model.BlockMD;
import journeymap.client.model.MapType;
import journeymap.client.properties.ClientCategory;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.task.main.SoftResetTask;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.task.multi.RenderSpec;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.buttons.CopyConfigButton;
import journeymap.client.ui.component.buttons.IntSliderButton;
import journeymap.client.ui.component.buttons.ResetButton;
import journeymap.client.ui.component.buttons.TextFieldButton;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.option.ButtonListSlot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.OptionScreen;
import journeymap.client.ui.option.OptionSlotFactory;
import journeymap.client.ui.option.OptionsScrollListPane;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.waypoint.WaypointHandler;
import journeymap.common.Journeymap;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.catagory.Category;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class ClientOptionsManager
extends OptionScreen {
    protected static Set<Category> openCategories = new HashSet<Category>();
    protected final int inGameMinimapId;
    protected Category[] initialCategories;
    protected CheckBox minimap1PreviewButton;
    protected CheckBox minimap2PreviewButton;
    protected Button renderStatsButton;
    protected Button editGridMinimap1Button;
    protected Button editGridMinimap2Button;
    protected Button editMinimap1LocationsButton;
    protected Button editMinimap2LocationsButton;
    protected Button editGridFullscreenButton;
    protected SlotMetadata renderStatsSlotMetadata;
    protected CategorySlot cartographyCategorySlot;
    protected OptionsScrollListPane<CategorySlot> optionsListPane;
    protected Map<Category, List<SlotMetadata>> toolbars;
    protected Set<Category> changedCategories = new HashSet<Category>();
    protected boolean forceMinimapUpdate;
    protected ButtonList editGridButtons = new ButtonList();
    private MiniMapProperties currentMiniMapProp;
    private MiniMap currentMiniMap;

    public ClientOptionsManager() {
        this(null, false);
    }

    public ClientOptionsManager(class_437 returnDisplay, boolean clientOnly) {
        this(returnDisplay, clientOnly, openCategories.toArray(new Category[0]));
    }

    public ClientOptionsManager(class_437 returnDisplay, boolean clientOnly, Category ... initialCategories) {
        super(String.format("JourneyMap %s %s", Journeymap.JM_VERSION, Constants.getString("jm.common.options")), returnDisplay, clientOnly);
        this.initialCategories = initialCategories;
        this.inGameMinimapId = JourneymapClient.getInstance().getActiveMinimapId();
    }

    public ClientOptionsManager(String title, class_437 returnDisplay, boolean clientOnly) {
        super(title, returnDisplay, clientOnly);
        this.inGameMinimapId = JourneymapClient.getInstance().getActiveMinimapId();
    }

    protected Map<Category, PropertiesBase> getSlots() {
        HashMap slotMap = Maps.newHashMap();
        slotMap.put(ClientCategory.MiniMap1, JourneymapClient.getInstance().getMiniMapProperties1());
        slotMap.put(ClientCategory.MiniMap2, JourneymapClient.getInstance().getMiniMapProperties2());
        slotMap.put(ClientCategory.FullMap, JourneymapClient.getInstance().getFullMapProperties());
        slotMap.put(ClientCategory.WebMap, JourneymapClient.getInstance().getWebMapProperties());
        slotMap.put(ClientCategory.Waypoint, JourneymapClient.getInstance().getWaypointProperties());
        slotMap.put(ClientCategory.Advanced, JourneymapClient.getInstance().getCoreProperties());
        return slotMap;
    }

    @Override
    public void method_25426() {
        try {
            String tooltip;
            String name;
            super.method_25426();
            this.clientOptions.setEnabled(false);
            if (this.editGridMinimap1Button == null) {
                name = Constants.getString("jm.common.grid_edit");
                tooltip = Constants.getString("jm.common.grid_edit.tooltip");
                this.editGridMinimap1Button = new Button(name);
                this.editGridMinimap1Button.setTooltip(tooltip);
                this.editGridMinimap1Button.setDrawBackground(false);
                this.editGridMinimap2Button = new Button(name);
                this.editGridMinimap2Button.setTooltip(tooltip);
                this.editGridMinimap2Button.setDrawBackground(false);
                this.editGridFullscreenButton = new Button(name);
                this.editGridFullscreenButton.setTooltip(tooltip);
                this.editGridFullscreenButton.setDrawBackground(false);
                this.editGridButtons = new ButtonList(this.editGridMinimap1Button, this.editGridMinimap2Button, this.editGridFullscreenButton);
            }
            if (this.editMinimap1LocationsButton == null) {
                name = Constants.getString("jm.common.minimap_position.button");
                tooltip = Constants.getString("jm.common.minimap_position.button.tooltip");
                this.editMinimap1LocationsButton = new Button(name);
                this.editMinimap1LocationsButton.setTooltip(tooltip);
                this.editMinimap1LocationsButton.setDrawBackground(false);
                this.editMinimap2LocationsButton = new Button(name);
                this.editMinimap2LocationsButton.setTooltip(tooltip);
                this.editMinimap2LocationsButton.setDrawBackground(false);
            }
            if (this.minimap1PreviewButton == null) {
                name = String.format("%s %s", Constants.getString("jm.minimap.preview"), "1");
                tooltip = Constants.getString("jm.minimap.preview.tooltip", JourneymapClient.getInstance().getKeyEvents().getHandler().kbMinimapPreset.getTranslatedName());
                this.minimap1PreviewButton = new CheckBox(name, false);
                this.minimap1PreviewButton.setTooltip(tooltip);
                if (class_310.method_1551().field_1687 == null) {
                    this.minimap1PreviewButton.setEnabled(false);
                }
            }
            if (this.minimap2PreviewButton == null) {
                name = String.format("%s %s", Constants.getString("jm.minimap.preview"), "2");
                tooltip = Constants.getString("jm.minimap.preview.tooltip", JourneymapClient.getInstance().getKeyEvents().getHandler().kbMinimapPreset.getTranslatedName());
                this.minimap2PreviewButton = new CheckBox(name, false);
                this.minimap2PreviewButton.setTooltip(tooltip);
                if (class_310.method_1551().field_1687 == null) {
                    this.minimap2PreviewButton.setEnabled(false);
                }
            }
            if (this.renderStatsButton == null) {
                this.renderStatsButton = new LabelButton(150, "jm.common.renderstats", 0, 0, 0);
                this.renderStatsButton.setEnabled(false);
            }
            if (this.optionsListPane == null) {
                ArrayList<CategorySlot> categorySlots = new ArrayList<CategorySlot>();
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                this.optionsListPane = new OptionsScrollListPane(this.field_22787, 0, 70, this.field_22789, this.field_22790 - 70 - 30, 20);
                this.optionsListPane.setAlignTop(true);
                this.optionsListPane.setSlots(OptionSlotFactory.getOptionSlots(this.getToolbars(), this.getSlots()));
                if (this.initialCategories != null) {
                    for (Category initialCategory : this.initialCategories) {
                        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
                            if (categorySlot.getCategory() != initialCategory) continue;
                            categorySlot.setSelected(true);
                            categorySlots.add(categorySlot);
                        }
                    }
                }
                for (Slot rootSlot : this.optionsListPane.getRootSlots()) {
                    if (!(rootSlot instanceof CategorySlot)) continue;
                    CategorySlot categorySlot = (CategorySlot)rootSlot;
                    Category category = categorySlot.getCategory();
                    if (category == ClientCategory.MiniMap1) {
                        if (class_310.method_1551().field_1687 != null) {
                            categorySlot.getAllChildMetadata().add(new SlotMetadata((Button)this.minimap1PreviewButton, 6));
                        }
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap1Button, 5));
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editMinimap1LocationsButton, 4));
                        continue;
                    }
                    if (category == ClientCategory.MiniMap2) {
                        if (class_310.method_1551().field_1687 != null) {
                            categorySlot.getAllChildMetadata().add(new SlotMetadata((Button)this.minimap2PreviewButton, 6));
                        }
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap2Button, 5));
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editMinimap2LocationsButton, 4));
                        continue;
                    }
                    if (category == ClientCategory.FullMap) {
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap2Button, 4));
                        continue;
                    }
                    if (category != ClientCategory.Cartography) continue;
                    this.cartographyCategorySlot = categorySlot;
                    this.renderStatsSlotMetadata = new SlotMetadata(this.renderStatsButton, Constants.getString("jm.common.renderstats.title"), Constants.getString("jm.common.renderstats.tooltip"), 2);
                }
                this.optionsListPane.updateSlots();
                if (!categorySlots.isEmpty()) {
                    this.optionsListPane.scrollTo((Slot)((Object)categorySlots.get(0)));
                }
            } else {
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                this.optionsListPane.updateSize(this.field_22789, this.field_22790 - 70 - 30, 0, 70);
                this.optionsListPane.updateSlots();
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in OptionsManager.init(): " + String.valueOf(t), t);
        }
    }

    @Override
    protected void layoutButtons(class_332 graphics) {
        if (this.getRenderables().isEmpty()) {
            this.method_25426();
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float par3) {
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        graphics.method_25296(0, 36, this.field_22789, 70, -1072689136, -804253680);
        try {
            if (this.forceMinimapUpdate) {
                if (this.minimap1PreviewButton.method_37303()) {
                    UIManager.INSTANCE.switchMiniMapPreset(1);
                } else if (this.minimap2PreviewButton.method_37303()) {
                    UIManager.INSTANCE.switchMiniMapPreset(2);
                }
            }
            if (this.field_22787.field_1687 != null) {
                this.updateRenderStats();
            }
            List lastTooltip = this.optionsListPane.lastTooltip;
            long lastTooltipTime = this.optionsListPane.lastTooltipTime;
            this.optionsListPane.lastTooltip = null;
            this.optionsListPane.method_25394(graphics, mouseX, mouseY, par3);
            super.method_25394(graphics, mouseX, mouseY, par3);
            if (this.previewMiniMap() && !this.clientOnly) {
                UIManager.INSTANCE.getMiniMap().setDrawingInPreviewMode(true);
                UIManager.INSTANCE.getMiniMap().drawMap(graphics, true);
                UIManager.INSTANCE.getMiniMap().updateDisplayVars(true, false);
            } else {
                UIManager.INSTANCE.getMiniMap().setDrawingInPreviewMode(false);
            }
            if (!(this.optionsListPane.lastTooltip == null || this.previewMiniMap() && UIManager.INSTANCE.getMiniMap().withinBounds(mouseX, mouseY) || this.optionsListPane.lastTooltip.equals(lastTooltip))) {
                this.optionsListPane.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.optionsListPane.lastTooltipTime > this.optionsListPane.hoverDelay) {
                    Button button = this.optionsListPane.lastTooltipMetadata.getButton();
                    graphics.method_51447(this.field_22793, this.optionsListPane.lastTooltip, mouseX, button.getBottomY() + 15);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in OptionsManager.render(): " + String.valueOf(t), t);
        }
    }

    private void updateRenderStats() {
        RenderSpec.getSurfaceSpec();
        RenderSpec.getTopoSpec();
        RenderSpec.getUndergroundSpec();
        for (Slot rootSlot : this.optionsListPane.getRootSlots()) {
            CategorySlot categorySlot;
            if (!(rootSlot instanceof CategorySlot) || (categorySlot = (CategorySlot)rootSlot).getCategory() != ClientCategory.Cartography) continue;
            CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                int renderDistance;
                if (!(slotMetadata.getButton() instanceof IConfigFieldHolder)) continue;
                Object property = ((IConfigFieldHolder)((Object)slotMetadata.getButton())).getConfigField();
                boolean limitButtonRange = false;
                if (property == coreProperties.renderDistanceCaveMax) {
                    limitButtonRange = true;
                    slotMetadata.getButton().resetLabelColors();
                } else if (property == coreProperties.renderDistanceSurfaceMax) {
                    limitButtonRange = true;
                    slotMetadata.getButton().resetLabelColors();
                }
                if (!limitButtonRange) continue;
                IntSliderButton button = (IntSliderButton)slotMetadata.getButton();
                button.maxValue = renderDistance = JourneymapClient.getInstance().getRenderDistance();
                if (button.getValue() <= renderDistance) continue;
                button.setValue(renderDistance);
            }
        }
        String messageString = JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get() != false ? MapPlayerTask.getSimpleStats() : Constants.getString("jm.common.enable_mapping_false_text");
        this.renderStatsButton.method_25355((class_2561)Constants.getStringTextComponent(messageString));
        if (this.cartographyCategorySlot != null) {
            this.renderStatsButton.method_25358(this.cartographyCategorySlot.getCurrentColumnWidth());
        }
    }

    @Override
    public void method_25420(class_332 graphics, int i, int j, float f) {
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.previewMiniMap() && UIManager.INSTANCE.getMiniMap().withinBounds(mouseX, mouseY)) {
            return false;
        }
        try {
            boolean pressed = this.optionsListPane.method_25402(mouseX, mouseY, mouseButton);
            if (pressed) {
                this.checkPressedButton();
            }
            return super.method_25402(mouseX, mouseY, mouseButton);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(t.getMessage(), t);
            return false;
        }
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        this.optionsListPane.method_25406(mouseX, mouseY, mouseButton);
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.optionsListPane.method_25403(mouseX, mouseY, button, mouseDX, mouseDY)) {
            this.checkPressedButton();
        }
        return super.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean method_25401(double x, double y, double f, double scroll) {
        this.optionsListPane.method_25401(x, y, f, scroll);
        return super.method_25401(x, y, f, scroll);
    }

    protected void checkPressedButton() {
        CategorySlot categorySlot;
        SlotMetadata slotMetadata = this.optionsListPane.getLastPressed();
        if (slotMetadata != null) {
            if (slotMetadata.getButton() instanceof ResetButton) {
                this.resetOptions(((ResetButton)slotMetadata.getButton()).category);
            }
            if (slotMetadata.getName().equals(Constants.getString("jm.common.ui_theme"))) {
                ThemeLoader.getCurrentTheme(true);
                if (this.previewMiniMap()) {
                    UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
                }
            }
            if (this.editGridButtons.contains((Object)slotMetadata.getButton())) {
                UIManager.INSTANCE.openGridEditor(this);
                return;
            }
            if (slotMetadata.getButton() == this.editMinimap1LocationsButton) {
                UIManager.INSTANCE.openMinimapPosition(this, JourneymapClient.getInstance().getMiniMapProperties(1));
                return;
            }
            if (slotMetadata.getButton() == this.editMinimap2LocationsButton) {
                UIManager.INSTANCE.openMinimapPosition(this, JourneymapClient.getInstance().getMiniMapProperties(2));
                return;
            }
            if (slotMetadata.getButton() == this.minimap1PreviewButton) {
                this.minimap2PreviewButton.setToggled(false);
                UIManager.INSTANCE.switchMiniMapPreset(1);
                UIManager.INSTANCE.getMiniMap().resetInitTime();
                this.currentMiniMap = UIManager.INSTANCE.getMiniMap();
                this.currentMiniMapProp = this.currentMiniMap.getCurrentMinimapProperties();
            }
            if (slotMetadata.getButton() == this.minimap2PreviewButton) {
                this.minimap1PreviewButton.setToggled(false);
                UIManager.INSTANCE.switchMiniMapPreset(2);
                UIManager.INSTANCE.getMiniMap().resetInitTime();
                this.currentMiniMap = UIManager.INSTANCE.getMiniMap();
                this.currentMiniMapProp = this.currentMiniMap.getCurrentMinimapProperties();
            }
        }
        if ((categorySlot = (CategorySlot)this.optionsListPane.getLastPressedParentSlot()) != null) {
            Category category = categorySlot.getCategory();
            this.changedCategories.add(category);
            if (category == ClientCategory.MiniMap1 || category == ClientCategory.MiniMap2) {
                this.refreshMinimapOptions();
                DataCache.INSTANCE.resetRadarCaches();
                UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
            }
            if (category == ClientCategory.Cartography) {
                JourneymapClient.getInstance().getCoreProperties().save();
                RenderSpec.resetRenderSpecs();
            }
        }
    }

    protected void actionPerformed(Button button) {
        if (button == this.minimap1PreviewButton) {
            this.minimap2PreviewButton.setToggled(false);
            UIManager.INSTANCE.switchMiniMapPreset(1);
        }
        if (button == this.minimap2PreviewButton) {
            this.minimap1PreviewButton.setToggled(false);
            UIManager.INSTANCE.switchMiniMapPreset(2);
        }
    }

    @Override
    public boolean method_25400(char typedChar, int keyCode) {
        switch (keyCode) {
            case 256: {
                if (this.previewMiniMap()) {
                    this.minimap1PreviewButton.setToggled(false);
                    this.minimap2PreviewButton.setToggled(false);
                    break;
                }
                this.closeAndReturn();
            }
        }
        boolean optionUpdated = this.optionsListPane.method_25400(typedChar, keyCode);
        if (optionUpdated && this.previewMiniMap()) {
            UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
        }
        return true;
    }

    @Override
    public boolean method_25404(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                if (this.previewMiniMap()) {
                    this.minimap1PreviewButton.setToggled(false);
                    this.minimap2PreviewButton.setToggled(false);
                    break;
                }
                this.closeAndReturn();
            }
        }
        boolean optionUpdated = this.optionsListPane.method_25404(key, value, modifier);
        if (optionUpdated && this.previewMiniMap()) {
            UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
        }
        return optionUpdated;
    }

    protected void resetOptions(Category category) {
        HashSet<PropertiesBase> updatedProperties = new HashSet<PropertiesBase>();
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!category.equals(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                PropertiesBase properties;
                slotMetadata.resetToDefaultValue();
                if ((ClientCategory.MiniMap1.equals(category) || ClientCategory.MiniMap2.equals(category)) && !this.clientOnly) {
                    UIManager.INSTANCE.getMiniMap().resetState();
                }
                if (ClientCategory.FullMap.equals(category) && !this.clientOnly) {
                    Fullscreen.state().setMapType(MapType.Name.day);
                }
                if (!slotMetadata.hasConfigField() || (properties = slotMetadata.getProperties()) == null) continue;
                updatedProperties.add(properties);
            }
        }
        for (PropertiesBase properties : updatedProperties) {
            properties.save();
        }
        if (!this.clientOnly) {
            RenderSpec.resetRenderSpecs();
        }
    }

    protected void updateOnCopy(Category category) {
        HashSet<PropertiesBase> updatedProperties = new HashSet<PropertiesBase>();
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!category.equals(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                if (!slotMetadata.hasConfigField()) continue;
                PropertiesBase properties = slotMetadata.getProperties();
                if (properties != null) {
                    updatedProperties.add(properties);
                }
                slotMetadata.getButton().refresh();
            }
        }
        for (PropertiesBase properties : updatedProperties) {
            properties.save();
        }
        this.optionsListPane.updateSlots();
    }

    public boolean previewMiniMap() {
        return this.minimap1PreviewButton.getToggled() != false || this.minimap2PreviewButton.getToggled() != false;
    }

    public void refreshMinimapOptions() {
        HashSet<Category> cats = new HashSet<Category>();
        cats.add(ClientCategory.MiniMap1);
        cats.add(ClientCategory.MiniMap2);
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!cats.contains(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                slotMetadata.getButton().refresh();
            }
        }
    }

    @Override
    public void closeWithKeyBind() {
        TextFieldButton button;
        ButtonListSlot buttonListSlot;
        Object object = this.optionsListPane.method_25334();
        if (object instanceof ButtonListSlot && (object = (buttonListSlot = (ButtonListSlot)object).getLastPressed().getButton()) instanceof TextFieldButton && (button = (TextFieldButton)object).method_25370()) {
            return;
        }
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        JourneymapClient.getInstance().getCoreProperties().optionsManagerViewed.set(Journeymap.JM_VERSION.toString()).save();
        JourneymapClient.getInstance().saveConfigProperties();
        if (this.field_22787.field_1687 != null) {
            UIManager.INSTANCE.getMiniMap().setMiniMapProperties(JourneymapClient.getInstance().getMiniMapProperties(this.inGameMinimapId));
            for (Category category : this.changedCategories) {
                if (category == ClientCategory.MiniMap1) {
                    DataCache.INSTANCE.resetRadarCaches();
                    UIManager.INSTANCE.getMiniMap().reset();
                    continue;
                }
                if (category == ClientCategory.MiniMap2) {
                    DataCache.INSTANCE.resetRadarCaches();
                    continue;
                }
                if (category == ClientCategory.FullMap) {
                    DataCache.INSTANCE.resetRadarCaches();
                    ThemeLoader.getCurrentTheme(true);
                    continue;
                }
                if (category == ClientCategory.WebMap) {
                    if (JourneymapClient.getInstance().getWebMap() == null) continue;
                    DataCache.INSTANCE.resetRadarCaches();
                    if (JourneymapClient.getInstance().getWebMapProperties().enabled.get().booleanValue()) {
                        JourneymapClient.getInstance().getWebMap().start();
                    } else {
                        JourneymapClient.getInstance().getWebMap().stop();
                    }
                    ChatLog.announceMod(true);
                    continue;
                }
                if (category == ClientCategory.Waypoint) {
                    WaypointHandler.getInstance().reset();
                    continue;
                }
                if (category == ClientCategory.WaypointBeacon) continue;
                if (category == ClientCategory.Cartography) {
                    ModBlockDelegate.INSTANCE.reset();
                    BlockMD.reset();
                    RenderSpec.resetRenderSpecs();
                    MiniMap.state().requireRefresh();
                    Fullscreen.state().requireRefresh();
                    MapPlayerTask.forceNearbyRemap();
                    continue;
                }
                if (category != ClientCategory.Advanced) continue;
                SoftResetTask.queue();
                try {
                    if (JourneymapClient.getInstance().getWebMapProperties().enabled.get().booleanValue()) {
                        JourneymapClient.getInstance().startWebMap();
                    } else {
                        JourneymapClient.getInstance().stopWebMap();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ChatLog.announceMod(false);
            }
            UIManager.INSTANCE.getMiniMap().reset();
            UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
        }
        if (returnDisplayStack != null && !returnDisplayStack.isEmpty() && returnDisplayStack.peek() instanceof Fullscreen) {
            ((Fullscreen)((Object)returnDisplayStack.peek())).reset();
        }
        openCategories.clear();
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!categorySlot.isSelected()) continue;
            openCategories.add(categorySlot.getCategory());
        }
        super.closeAndReturn();
    }

    protected Map<Category, List<SlotMetadata>> getToolbars() {
        if (this.toolbars == null) {
            this.toolbars = new HashMap<Category, List<SlotMetadata>>();
            for (Category category : ClientCategory.values) {
                ArrayList<SlotMetadata> toolbarButtons = new ArrayList<SlotMetadata>();
                if (ClientCategory.MiniMap1.equals(category)) {
                    this.addToolbarCopyButton(toolbarButtons, ClientCategory.MiniMap1, ClientCategory.MiniMap2, ClientCategory.FullMap);
                }
                if (ClientCategory.MiniMap2.equals(category)) {
                    this.addToolbarCopyButton(toolbarButtons, ClientCategory.MiniMap2, ClientCategory.MiniMap1, ClientCategory.FullMap);
                }
                if (ClientCategory.FullMap.equals(category)) {
                    this.addToolbarCopyButton(toolbarButtons, ClientCategory.FullMap, ClientCategory.MiniMap1, ClientCategory.MiniMap2);
                }
                toolbarButtons.add(new SlotMetadata((Button)new ResetButton(category), Constants.getString("jm.config.reset"), Constants.getString("jm.config.reset.tooltip"), 0));
                this.toolbars.put(category, toolbarButtons);
            }
        }
        return this.toolbars;
    }

    private void addToolbarCopyButton(List<SlotMetadata> buttons, Category from, Category ... to) {
        CopyConfigButton button = new CopyConfigButton(Constants.getString("jm.common.options.copy_to"), from, to, this::updateOnCopy);
        button.setTooltip("Copy");
        button.setDrawBackground(false);
        buttons.add(new SlotMetadata((Button)button, Constants.getString("jm.common.options.copy_to"), Constants.getString("jm.common.options.copy_to.tooltip"), 1));
    }

    public static class LabelButton
    extends Button {
        DrawUtil.HAlign hAlign = DrawUtil.HAlign.Left;

        public LabelButton(int width, String key, Object ... labelArgs) {
            super(Constants.getString(key, labelArgs));
            this.setTooltip(Constants.getString(key + ".tooltip"));
            this.setDrawBackground(false);
            this.setDrawFrame(false);
            this.setEnabled(false);
            this.setLabelColors(0xC0C0C0, 0xC0C0C0, 0xC0C0C0);
            this.method_25358(width);
        }

        @Override
        public int getFitWidth(class_327 fr) {
            return this.field_22758;
        }

        @Override
        public void fitWidth(class_327 fr) {
        }

        public void setHAlign(DrawUtil.HAlign hAlign) {
            this.hAlign = hAlign;
        }

        @Override
        public void method_48579(class_332 graphics, int mouseX, int mouseY, float ticks) {
            DrawUtil.drawLabel(graphics, this.method_25369().getString(), switch (this.hAlign) {
                case DrawUtil.HAlign.Left -> this.getRightX();
                case DrawUtil.HAlign.Right -> this.method_46426();
                default -> this.getCenterX();
            }, this.getMiddleY(), this.hAlign, DrawUtil.VAlign.Middle, null, 0.0f, this.labelColor, 1.0f, 1.0, this.drawLabelShadow);
        }
    }
}

