/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import journeymap.client.JourneymapClient;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.ClientWaypointImpl;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class DrawWayPointStep
implements DrawStep {
    public final ClientWaypointImpl waypoint;
    final Integer color;
    final Integer fontColor;
    final Texture texture;
    final boolean isEdit;
    Point2D.Double lastPosition;
    boolean lastOnScreen;
    boolean showLabel;
    double labelScale = 0.0;
    float iconScale = 0.0f;

    public DrawWayPointStep(ClientWaypointImpl waypoint) {
        this(waypoint, waypoint.getIconColor(), waypoint.isDeathPoint() ? 0xFF0000 : waypoint.getSafeColor(), false);
    }

    public DrawWayPointStep(ClientWaypointImpl waypoint, Integer color, Integer fontColor, boolean isEdit) {
        this.waypoint = waypoint;
        this.color = color;
        this.fontColor = fontColor;
        this.isEdit = isEdit;
        this.texture = waypoint.getTexture();
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public void setLabelScale(float labelScale) {
        this.labelScale = labelScale;
    }

    public void setIconScale(float iconScale) {
        this.iconScale = iconScale;
    }

    @Override
    public void draw(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (!(this.waypoint.isInPlayerDimension() && JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed() && JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get().booleanValue())) {
            return;
        }
        Point2D.Double pixel = this.getPosition(xOffset, yOffset, renderer, true);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 800.0f);
        if (renderer.isOnScreen(pixel)) {
            if (this.showLabel && (pass == DrawStep.Pass.TextBG || pass == DrawStep.Pass.Text)) {
                int labelOffset = rotation == 0.0 ? -this.texture.getHeight() / 2 : this.texture.getHeight() / 2;
                labelOffset = this.iconScale <= 1.0f ? labelOffset : (int)((float)labelOffset * this.iconScale);
                this.labelScale = this.labelScale == 0.0 ? fontScale : this.labelScale;
                Point2D labelPoint = renderer.shiftWindowPosition(pixel.getX(), pixel.getY(), 0, labelOffset);
                String waypointName = this.waypoint.getName();
                if (this.waypoint.isDeathPoint() && !JourneymapClient.getInstance().getWaypointProperties().showDeathpointlabel.get().booleanValue()) {
                    waypointName = "";
                }
                DrawUtil.drawBatchLabel(graphics.method_51448(), (class_2561)class_2561.method_43470((String)waypointName), pass, buffers, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, 0, 0.7f, (int)this.fontColor, 1.0f, this.labelScale, false, rotation);
            } else if (this.isEdit && pass == DrawStep.Pass.PreObject) {
                Texture editTex = TextureCache.getTexture(TextureCache.WaypointEdit);
                class_1921 renderType = JMRenderTypes.getIcon(editTex);
                class_4588 vertexBuilder = buffers.getBuffer(renderType);
                DrawUtil.drawWaypointIcon(graphics.method_51448(), vertexBuilder, editTex, this.iconScale, this.color, 1.0f, pixel.getX(), pixel.getY(), rotation);
            }
            if (pass == DrawStep.Pass.Object) {
                class_1921 renderType = JMRenderTypes.getIcon(this.texture);
                class_4588 vertexBuilder = buffers.getBuffer(renderType);
                DrawUtil.drawWaypointIcon(graphics.method_51448(), vertexBuilder, this.texture, this.iconScale, this.color, 1.0f, pixel.getX(), pixel.getY(), rotation);
            }
        } else if (!this.isEdit && pass == DrawStep.Pass.Object) {
            renderer.ensureOnScreen(pixel);
            class_1921 renderType = JMRenderTypes.getIcon(this.texture);
            class_4588 vertexBuilder = buffers.getBuffer(renderType);
            DrawUtil.drawWaypointIcon(graphics.method_51448(), vertexBuilder, this.texture, this.iconScale, this.color, 1.0f, pixel.getX(), pixel.getY(), rotation);
        }
        graphics.method_51448().method_22909();
    }

    public void drawOffscreen(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, Point2D pixel, double rotation) {
        if (pass == DrawStep.Pass.Object) {
            class_1921 renderType = JMRenderTypes.getIconUnmasked(this.texture);
            class_4588 vertexBuilder = buffers.getBuffer(renderType);
            DrawUtil.drawWaypointIcon(graphics.method_51448(), vertexBuilder, this.texture, this.iconScale, this.color, 1.0f, pixel.getX() - (double)(this.texture.getWidth() >> 1), pixel.getY() - (double)(this.texture.getHeight() >> 1), rotation);
        }
    }

    public Point2D.Double getPosition(double xOffset, double yOffset, Renderer renderer, boolean forceUpdate) {
        if (!forceUpdate && this.lastPosition != null) {
            return this.lastPosition;
        }
        double x = (double)this.waypoint.getX() + 0.5;
        double z = (double)this.waypoint.getZ() + 0.5;
        Point2D.Double pixel = renderer.getBlockPixelInGrid(x, z);
        pixel.setLocation(pixel.getX() + xOffset, pixel.getY() + yOffset);
        this.lastPosition = pixel;
        return pixel;
    }

    public boolean isOnScreen() {
        return this.lastOnScreen;
    }

    public void setOnScreen(boolean lastOnScreen) {
        this.lastOnScreen = lastOnScreen;
    }

    @Override
    public int getDisplayOrder() {
        return 0;
    }

    @Override
    public String getModId() {
        return this.waypoint.getOrigin();
    }

    public static class SimpleCacheLoader
    extends CacheLoader<ClientWaypointImpl, DrawWayPointStep> {
        public DrawWayPointStep load(ClientWaypointImpl holder) throws Exception {
            return new DrawWayPointStep(holder);
        }
    }
}

