/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.plugins.vanilla.crafting.CategoryRecipeValidator;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_310;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_638;
import net.minecraft.class_8059;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public final class VanillaRecipes {
    private final class_1863 recipeManager;
    private final IIngredientManager ingredientManager;

    public VanillaRecipes(IIngredientManager ingredientManager) {
        class_310 minecraft = class_310.method_1551();
        ErrorUtil.checkNotNull(minecraft, "minecraft");
        class_638 world = minecraft.field_1687;
        ErrorUtil.checkNotNull(world, "minecraft world");
        this.recipeManager = world.method_8433();
        this.ingredientManager = ingredientManager;
    }

    public Map<Boolean, List<class_8786<class_3955>>> getCraftingRecipes(IRecipeCategory<class_8786<class_3955>> craftingCategory) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(craftingCategory, this.ingredientManager, 9);
        return this.recipeManager.method_30027(class_3956.field_17545).stream().filter(validator::isRecipeValid).collect(Collectors.partitioningBy(validator::isRecipeHandled));
    }

    public List<class_8786<class_3975>> getStonecuttingRecipes(IRecipeCategory<class_8786<class_3975>> stonecuttingCategory) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(stonecuttingCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_17641, validator);
    }

    public List<class_8786<class_3861>> getFurnaceRecipes(IRecipeCategory<class_8786<class_3861>> furnaceCategory) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(furnaceCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_17546, validator);
    }

    public List<class_8786<class_3862>> getSmokingRecipes(IRecipeCategory<class_8786<class_3862>> smokingCategory) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(smokingCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_17548, validator);
    }

    public List<class_8786<class_3859>> getBlastingRecipes(IRecipeCategory<class_8786<class_3859>> blastingCategory) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(blastingCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_17547, validator);
    }

    public List<class_8786<class_3920>> getCampfireCookingRecipes(IRecipeCategory<class_8786<class_3920>> campfireCategory) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(campfireCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_17549, validator);
    }

    public List<class_8786<class_8059>> getSmithingRecipes(IRecipeCategory<class_8786<class_8059>> smithingCategory) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(smithingCategory, this.ingredientManager, 0);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, class_3956.field_25388, validator);
    }

    private static <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> getValidHandledRecipes(class_1863 recipeManager, class_3956<T> recipeType, CategoryRecipeValidator<T> validator) {
        return recipeManager.method_30027(recipeType).stream().filter(r -> validator.isRecipeValid((class_8786)r) && validator.isRecipeHandled((class_8786)r)).toList();
    }
}

