/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.inventoryessentials.InventoryEssentials;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.client.ClientOnlyInventoryControls;
import net.blay09.mods.inventoryessentials.client.CreativeInventoryControls;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.blay09.mods.inventoryessentials.client.ModKeyMappings;
import net.blay09.mods.inventoryessentials.client.ServerSupportedInventoryControls;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.inventoryessentials.mixin.CreativeModeInventoryScreenAccessor;
import net.minecraft.class_1661;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class InventoryEssentialsClient {
    private static final InventoryControls clientOnlyControls = new ClientOnlyInventoryControls();
    private static final InventoryControls creativeControls = new CreativeInventoryControls();
    private static final InventoryControls serverSupportedControls = new ServerSupportedInventoryControls();
    private static class_1735 lastDragHoverSlot;

    public static void initialize() {
        ModKeyMappings.initialize();
        Balm.getEvents().onEvent(ScreenMouseEvent.Drag.Pre.class, InventoryEssentialsClient::onMouseDrag);
    }

    public static InventoryControls getInventoryControls(class_437 screen) {
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            return creativeControls;
        }
        return InventoryEssentials.isServerSideInstalled && !InventoryEssentialsConfig.getActive().forceClientImplementation ? serverSupportedControls : clientOnlyControls;
    }

    public static boolean shouldHandleInput(class_437 screen) {
        if (!(screen instanceof AbstractContainerScreenAccessor)) {
            return false;
        }
        AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)screen;
        class_1735 hoverSlot = accessor.getHoveredSlot();
        if (hoverSlot instanceof class_1734) {
            return false;
        }
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            CreativeModeInventoryScreenAccessor creativeAccessor = (CreativeModeInventoryScreenAccessor)screen;
            return hoverSlot == null || hoverSlot.field_7871 instanceof class_1661 || hoverSlot.field_7871 != creativeAccessor.getCONTAINER();
        }
        return true;
    }

    public static void onMouseDrag(ScreenMouseEvent.Drag.Pre event) {
        if (ModKeyMappings.keyDragTransfer.isActiveAndDown()) {
            class_437 class_4372 = event.getScreen();
            if (class_4372 instanceof class_465) {
                class_465 screen = (class_465)class_4372;
                class_1735 hoverSlot = ((AbstractContainerScreenAccessor)screen).getHoveredSlot();
                if (hoverSlot == null || !InventoryEssentialsClient.shouldHandleInput((class_437)screen) || !InventoryEssentialsClient.shouldHandleSlot(hoverSlot)) {
                    return;
                }
                if (hoverSlot.method_7681() && hoverSlot != lastDragHoverSlot) {
                    InventoryControls controls = InventoryEssentialsClient.getInventoryControls((class_437)screen);
                    controls.dragTransfer(screen, hoverSlot);
                    lastDragHoverSlot = hoverSlot;
                }
            }
        } else {
            lastDragHoverSlot = null;
        }
    }

    private static boolean shouldHandleSlot(class_1735 slot) {
        return slot.field_7871 != null && slot.field_7871.method_5439() != 0;
    }
}

