/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.IEditing;
import net.minecraft.class_437;

public class EditingTracker {
    private IModConfig editingConfig;
    private static EditingTracker instance;

    public static EditingTracker instance() {
        if (instance == null) {
            instance = new EditingTracker();
        }
        return instance;
    }

    private EditingTracker() {
    }

    public void onScreenOpen(class_437 screen) {
        if (screen instanceof IEditing) {
            IEditing editing = (IEditing)screen;
            if (this.editingConfig == null) {
                this.editingConfig = editing.getActiveConfig();
                this.editingConfig.startEditing();
                Constants.LOG.info("Started editing '" + this.editingConfig.getFileName() + "'");
            } else {
                if (editing.getActiveConfig() == null) {
                    throw new NullPointerException("A null config was returned when getting active config");
                }
                if (this.editingConfig != editing.getActiveConfig()) {
                    throw new IllegalStateException("Trying to edit a config while one is already loaded. This should not happen!");
                }
            }
        } else if (this.editingConfig != null) {
            Constants.LOG.info("Stopped editing '" + this.editingConfig.getFileName() + "'");
            this.editingConfig.stopEditing();
            this.editingConfig = null;
        }
    }
}

