/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8015;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8028;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.config.KeybindOptionButton;
import snownee.jade.gui.config.OptionsNav;
import snownee.jade.gui.config.value.CycleOptionValue;
import snownee.jade.gui.config.value.InputOptionValue;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.gui.config.value.SliderOptionValue;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.SmoothChasingValue;

public class OptionsList
extends class_4265<Entry> {
    public static final class_2561 OPTION_ON = class_5244.field_24332.method_27661().method_27694(style -> style.method_36139(-4589878));
    public static final class_2561 OPTION_OFF = class_5244.field_24333.method_27661().method_27694(style -> style.method_36139(-30080));
    public final Set<Entry> forcePreview = Sets.newIdentityHashSet();
    protected final List<Entry> entries = Lists.newArrayList();
    private final Runnable diskWriter;
    public Title currentTitle;
    public class_304 selectedKey;
    private BaseOptionsScreen owner;
    private final SmoothChasingValue smoothScroll;
    private Entry defaultParent;

    public OptionsList(BaseOptionsScreen owner, class_310 client, int width, int height, int y0, int entryHeight, Runnable diskWriter) {
        super(client, width, height, y0, entryHeight);
        this.owner = owner;
        this.diskWriter = diskWriter;
        this.smoothScroll = new SmoothChasingValue().withSpeed(0.6f);
    }

    public OptionsList(BaseOptionsScreen owner, class_310 client, int width, int height, int y0, int entryHeight) {
        this(owner, client, width, height, y0, entryHeight, null);
    }

    private static void walkChildren(Entry entry, Consumer<Entry> consumer) {
        consumer.accept(entry);
        for (Entry child : entry.children) {
            OptionsList.walkChildren(child, consumer);
        }
    }

    public int method_25322() {
        return Math.min(this.field_22758, 300);
    }

    protected int method_25329() {
        return this.owner.field_22789 - 6;
    }

    public void method_25307(double scroll) {
        this.smoothScroll.target(class_3532.method_15363((float)((float)scroll), (float)0.0f, (float)this.method_25331()));
    }

    public void forceSetScrollAmount(double scroll) {
        this.smoothScroll.start((float)scroll);
        super.method_25307(scroll);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        double speed = !ClientProxy.hasFastScroll && class_437.method_25441() ? 4.5 : 1.5;
        this.method_25307((double)this.smoothScroll.getTarget() - deltaY * (double)this.field_22741 * speed);
        return true;
    }

    public boolean method_25403(double d, double e, int i, double f, double g) {
        this.smoothScroll.value = this.smoothScroll.getTarget();
        super.method_25307((double)this.smoothScroll.value);
        return super.method_25403(d, e, i, f, g);
    }

    public boolean method_25370() {
        return this.owner.method_25399() == this;
    }

    @Nullable
    public class_8016 method_48205(class_8023 event) {
        class_8023.class_8024 nav;
        OptionsNav.Entry navEntry = (OptionsNav.Entry)this.owner.getOptionsNav().method_25336();
        if (navEntry != null && event instanceof class_8023.class_8024 && (nav = (class_8023.class_8024)event).comp_1191() == class_8028.field_41829) {
            Title title = navEntry.getTitle();
            this.method_25395((class_364)title);
            class_8016 path = super.method_48205((class_8023)new class_8023.class_8024(class_8028.field_41827));
            this.method_25395(null);
            return path;
        }
        return super.method_48205(event);
    }

    public void ensureVisible(Entry entry) {
        super.method_25328((class_350.class_351)entry);
    }

    protected boolean method_25332(int i) {
        if (PreviewOptionsScreen.isAdjustingPosition()) {
            return false;
        }
        return Objects.equals(this.method_25334(), this.method_25396().get(i));
    }

    protected void method_57713(class_332 guiGraphics) {
        RenderSystem.enableBlend();
        class_2960 resourceLocation2 = this.field_22740.field_1687 == null ? class_437.field_49896 : class_437.field_49898;
        guiGraphics.method_25290(resourceLocation2, 0, this.method_55443(), 0.0f, 0.0f, this.owner.field_22789, 2, 32, 2);
        RenderSystem.disableBlend();
    }

    protected void method_44398(class_332 guiGraphics, int i, int j, int k, int l, int m) {
        guiGraphics.method_25294(this.method_46426(), i - 2, this.method_55442(), i + k + 2, 0x33FFFFFF);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.smoothScroll.tick(delta);
        super.method_25307((double)this.smoothScroll.value);
        this.field_33780 = null;
        if (!PreviewOptionsScreen.isAdjustingPosition()) {
            class_8015 lastInputType = this.field_22740.method_48186();
            mouseY = Math.min(mouseY, this.method_31383());
            if (lastInputType.method_48182() && this.method_25405(mouseX, mouseY)) {
                this.field_33780 = this.method_25308(mouseX, mouseY);
            } else if (lastInputType.method_48183() && this.method_25336() != null) {
                this.field_33780 = this.method_25336();
            }
            class_350.class_351 class_3512 = this.field_33780;
            if (class_3512 instanceof Title) {
                Title title = (Title)class_3512;
                this.method_25313(null);
                this.currentTitle = title;
            } else {
                Entry entry;
                this.method_25313((class_350.class_351)((Entry)this.field_33780));
                if (this.field_33780 != null && (entry = ((Entry)this.field_33780).root()) instanceof Title) {
                    Title title;
                    this.currentTitle = title = (Title)entry;
                }
            }
        }
        this.method_49603(guiGraphics);
        this.method_25311(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_44380();
        this.method_57713(guiGraphics);
        if (this.method_57717()) {
            int k = this.method_25329();
            int l = (int)((float)(this.field_22759 * this.field_22759) / (float)this.method_25317());
            l = class_3532.method_15340((int)l, (int)32, (int)(this.field_22759 - 8));
            int m = (int)this.method_25341() * (this.field_22759 - l) / this.method_25331() + this.method_46427();
            if (m < this.method_46427()) {
                m = this.method_46427();
            }
            RenderSystem.enableBlend();
            guiGraphics.method_52706(field_49477, k, this.method_46427(), 6, this.method_25364());
            guiGraphics.method_52706(field_45908, k, m, 6, l);
            RenderSystem.disableBlend();
        }
        this.method_25320(guiGraphics, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    public void save() {
        this.method_25396().stream().filter(e -> e instanceof OptionValue).map(e -> (OptionValue)((Object)e)).forEach(OptionValue::save);
        if (this.diskWriter != null) {
            this.diskWriter.run();
        }
    }

    public <T extends Entry> T add(T entry) {
        this.entries.add(entry);
        if (entry instanceof Title) {
            this.setDefaultParent(entry);
        } else if (this.defaultParent != null) {
            entry.parent(this.defaultParent);
        }
        return entry;
    }

    @Nullable
    public Entry getEntryAt(double x, double y) {
        return (Entry)this.method_25308(x, y);
    }

    public int method_25337(int i) {
        return super.method_25337(i);
    }

    public int method_25319(int i) {
        return super.method_25319(i);
    }

    public void setDefaultParent(Entry defaultParent) {
        this.defaultParent = defaultParent;
    }

    public class_5250 title(String string) {
        return this.add(new Title(string)).getTitle();
    }

    public OptionValue<Float> slider(String optionName, float value, Consumer<Float> setter) {
        return this.slider(optionName, value, setter, 0.0f, 1.0f, FloatUnaryOperator.identity());
    }

    public OptionValue<Float> slider(String optionName, float value, Consumer<Float> setter, float min, float max, FloatUnaryOperator aligner) {
        return this.add(new SliderOptionValue(optionName, value, setter, min, max, aligner));
    }

    public <T> OptionValue<T> input(String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        return this.add(new InputOptionValue<T>(this::updateSaveState, optionName, value, setter, validator));
    }

    public <T> OptionValue<T> input(String optionName, T value, Consumer<T> setter) {
        return this.input(optionName, value, setter, (Predicate<String>)Predicates.alwaysTrue());
    }

    public OptionValue<Boolean> choices(String optionName, boolean value, BooleanConsumer setter) {
        return this.choices(optionName, value, setter, null);
    }

    public OptionValue<Boolean> choices(String optionName, boolean value, BooleanConsumer setter, @Nullable Consumer<class_5676.class_5677<Boolean>> builderConsumer) {
        class_5676.class_5677 builder = class_5676.method_32607((class_2561)OPTION_ON, (class_2561)OPTION_OFF);
        if (builderConsumer != null) {
            builderConsumer.accept((class_5676.class_5677<Boolean>)builder);
        }
        return this.add(new CycleOptionValue<Boolean>(optionName, (class_5676.class_5677<Boolean>)builder, value, (Consumer<Boolean>)setter));
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, T value, Consumer<T> setter) {
        return this.choices(optionName, value, setter, null);
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, T value, Consumer<T> setter, @Nullable Consumer<class_5676.class_5677<T>> builderConsumer) {
        List<Enum> values = Arrays.asList((Enum[])value.getDeclaringClass().getEnumConstants());
        class_5676.class_5677 builder = class_5676.method_32606(v -> {
            String name;
            return switch (name = v.name().toLowerCase(Locale.ENGLISH)) {
                case "on" -> OPTION_ON;
                case "off" -> OPTION_OFF;
                default -> Entry.makeTitle(optionName + "_" + name);
            };
        }).method_32620(values);
        if (builderConsumer != null) {
            builderConsumer.accept(builder);
        }
        return this.add(new CycleOptionValue<T>(optionName, builder, value, setter));
    }

    public <T> OptionValue<T> choices(String optionName, T value, List<T> values, Consumer<T> setter, Function<T, class_2561> nameProvider) {
        return this.add(new CycleOptionValue<T>(optionName, class_5676.method_32606(nameProvider).method_32620(values), value, setter));
    }

    public void keybind(class_304 keybind) {
        this.add(new KeybindOptionButton(this, keybind));
    }

    public void removed() {
        this.forcePreview.clear();
        for (Entry entry : this.entries) {
            entry.parent = null;
            if (entry.children.isEmpty()) continue;
            entry.children.clear();
        }
        this.method_25339();
        this.owner = null;
    }

    public void updateSearch(String search) {
        this.method_25339();
        if (search.isBlank()) {
            this.entries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
            return;
        }
        LinkedHashSet matches = Sets.newLinkedHashSet();
        String[] keywords = search.split("\\s+");
        for (Entry entry : this.entries) {
            int bingo = 0;
            block1: for (String keyword : keywords) {
                keyword = keyword.toLowerCase(Locale.ENGLISH);
                for (String message : entry.getMessages()) {
                    if (!message.contains(keyword)) continue;
                    ++bingo;
                    continue block1;
                }
            }
            if (bingo != keywords.length) continue;
            OptionsList.walkChildren(entry, matches::add);
            while (entry.parent() != null) {
                entry = entry.parent();
                matches.add(entry);
            }
        }
        for (Entry entry : this.entries) {
            if (!matches.contains((Object)entry)) continue;
            this.method_25321((class_350.class_351)entry);
        }
        if (matches.isEmpty()) {
            this.method_25321((class_350.class_351)new Title(class_2561.method_43471((String)"gui.jade.no_results").method_27692(class_124.field_1080)));
        }
    }

    public void updateSaveState() {
        for (Entry entry : this.entries) {
            OptionValue value;
            if (!(entry instanceof OptionValue) || (value = (OptionValue)entry).isValidValue()) continue;
            this.owner.saveButton.field_22763 = false;
            return;
        }
        this.owner.saveButton.field_22763 = true;
    }

    public void showOnTop(Entry entry) {
        this.method_25307(this.field_22741 * this.method_25396().indexOf((Object)entry) + 1);
        if (entry instanceof Title) {
            Title title;
            this.currentTitle = title = (Title)entry;
        }
    }

    public void resetMappingAndUpdateButtons() {
        for (Entry entry : this.entries) {
            if (!(entry instanceof KeybindOptionButton)) continue;
            KeybindOptionButton button = (KeybindOptionButton)entry;
            button.refresh(this.selectedKey);
        }
    }

    public boolean method_25404(int i, int j, int k) {
        if (this.selectedKey != null) {
            class_315 options = class_310.method_1551().field_1690;
            if (i == 256) {
                options.method_1641(this.selectedKey, class_3675.field_16237);
            } else {
                options.method_1641(this.selectedKey, class_3675.method_15985((int)i, (int)j));
            }
            this.selectedKey = null;
            this.resetMappingAndUpdateButtons();
            return true;
        }
        return super.method_25404(i, j, k);
    }

    public boolean method_25402(double d, double e, int i) {
        if (this.selectedKey != null) {
            class_315 options = class_310.method_1551().field_1690;
            options.method_1641(this.selectedKey, class_3675.class_307.field_1672.method_1447(i));
            this.selectedKey = null;
            this.resetMappingAndUpdateButtons();
        }
        return super.method_25402(d, e, i);
    }

    public static class Entry
    extends class_4265.class_4266<Entry> {
        protected final class_310 client;
        private final List<String> messages = Lists.newArrayList();
        private final List<class_339> widgets = Lists.newArrayList();
        private final List<Vector2i> widgetOffsets = Lists.newArrayList();
        protected List<class_2561> description = List.of();
        private Entry parent;
        private List<Entry> children = List.of();

        public Entry() {
            this.client = class_310.method_1551();
        }

        public static class_5250 makeTitle(String key) {
            return class_2561.method_43471((String)Entry.makeKey(key));
        }

        public static String makeKey(String key) {
            return class_156.method_646((String)"config", (class_2960)class_2960.method_60655((String)"jade", (String)key));
        }

        public class_339 getFirstWidget() {
            return this.widgets.isEmpty() ? null : this.widgets.getFirst();
        }

        public void addWidget(class_339 widget, int offsetX) {
            this.addWidget(widget, offsetX, -widget.method_25364() / 2);
        }

        public void addWidget(class_339 widget, int offsetX, int offsetY) {
            this.widgets.add(widget);
            this.widgetOffsets.add(new Vector2i(offsetX, offsetY));
        }

        public List<? extends class_339> method_25396() {
            return this.widgets;
        }

        public List<? extends class_6379> method_37025() {
            return this.method_25396();
        }

        public void method_25343(class_332 guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            for (class_339 widget : this.widgets) {
                Vector2i offset = this.widgetOffsets.get(this.widgets.indexOf(widget));
                widget.method_46421(rowLeft + width - 110 + offset.x);
                widget.method_46419(rowTop + height / 2 + offset.y);
                widget.method_25394(guiGraphics, mouseX, mouseY, deltaTime);
            }
        }

        public void setDisabled(boolean b) {
            for (class_339 widget : this.widgets) {
                boolean bl = widget.field_22763 = !b;
                if (!(widget instanceof class_342)) continue;
                class_342 box = (class_342)widget;
                box.method_1888(!b);
            }
        }

        public List<class_2561> getDescription() {
            return this.description;
        }

        public List<class_2561> getDescriptionOnShift() {
            return List.of();
        }

        public int getTextX(int width) {
            return 0;
        }

        public int getTextWidth() {
            return 0;
        }

        public Entry parent(Entry parent) {
            this.parent = parent;
            if (parent.children.isEmpty()) {
                parent.children = Lists.newArrayList();
            }
            parent.children.add(this);
            return this;
        }

        public Entry parent() {
            return this.parent;
        }

        public Entry root() {
            Entry entry = this;
            while (entry.parent() != null) {
                entry = entry.parent();
            }
            return entry;
        }

        public final List<String> getMessages() {
            return this.messages;
        }

        public void addMessage(String message) {
            this.messages.add(class_3544.method_15440((String)message));
        }

        public void addMessageKey(String key) {
            if (class_1074.method_4663((String)(key = Entry.makeKey(key + "_extra_msg")))) {
                this.addMessage(class_1074.method_4662((String)key, (Object[])new Object[0]));
            }
        }
    }

    public static class Title
    extends Entry {
        public class_2561 narration;
        private final class_5250 title;
        private int x;

        public Title(String key) {
            this.title = Title.makeTitle(key);
            this.addMessageKey(key);
            this.addMessage(this.title.getString());
            key = Title.makeKey(key + "_desc");
            if (class_1074.method_4663((String)key)) {
                this.description = List.of(class_2561.method_43471((String)key));
                this.addMessage(((class_2561)this.description.getFirst()).getString());
            }
            this.narration = class_2561.method_43469((String)"narration.jade.category", (Object[])new Object[]{this.title});
        }

        public Title(class_5250 title) {
            this.title = title;
            this.narration = title;
        }

        public class_5250 getTitle() {
            return this.title;
        }

        @Override
        public void method_25343(class_332 guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            this.x = rowLeft;
            class_327 class_3272 = this.client.field_1772;
            int n = this.getTextX(width);
            Objects.requireNonNull(this.client.field_1772);
            guiGraphics.method_27535(class_3272, (class_2561)this.title, n, rowTop + height - 9, 0xFFFFFF);
        }

        @Override
        public int getTextX(int width) {
            return this.x + (width - this.client.field_1772.method_27525((class_5348)this.title)) / 2;
        }

        @Override
        public int getTextWidth() {
            return this.client.field_1772.method_27525((class_5348)this.title);
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return List.of(new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 narrationElementOutput) {
                    narrationElementOutput.method_37034(class_6381.field_33788, narration);
                }
            });
        }
    }
}

