/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers;

import com.seibel.distanthorizons.api.interfaces.block.IDhApiBiomeWrapper;
import com.seibel.distanthorizons.api.interfaces.block.IDhApiBlockStateWrapper;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.worldGeneration.AbstractBatchGenerationEnvironmentWrapper;
import java.io.IOException;
import java.util.HashSet;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_638;
import net.minecraft.class_6880;

public class WrapperFactory
implements IWrapperFactory {
    public static final WrapperFactory INSTANCE = new WrapperFactory();

    @Override
    public AbstractBatchGenerationEnvironmentWrapper createBatchGenerator(IDhLevel targetLevel) {
        if (targetLevel instanceof IDhServerLevel) {
            return new BatchGenerationEnvironment((IDhServerLevel)targetLevel);
        }
        throw new IllegalArgumentException("The target level must be a server-side level.");
    }

    @Override
    public IBiomeWrapper deserializeBiomeWrapper(String str, ILevelWrapper levelWrapper) throws IOException {
        return BiomeWrapper.deserialize(str, levelWrapper);
    }

    @Override
    public IBiomeWrapper getPlainsBiomeWrapper(ILevelWrapper levelWrapper) {
        try {
            return BiomeWrapper.deserialize("minecraft:plains", levelWrapper);
        }
        catch (IOException e) {
            throw new LodUtil.AssertFailureException("Unable to parse plains resource string [minecraft:plains], error:\n " + e.getMessage());
        }
    }

    @Override
    public IBlockStateWrapper deserializeBlockStateWrapper(String str, ILevelWrapper levelWrapper) throws IOException {
        return BlockStateWrapper.deserialize(str, levelWrapper);
    }

    @Override
    public IBlockStateWrapper getAirBlockStateWrapper() {
        return BlockStateWrapper.AIR;
    }

    @Override
    public HashSet<IBlockStateWrapper> getRendererIgnoredBlocks(ILevelWrapper levelWrapper) {
        return BlockStateWrapper.getRendererIgnoredBlocks(levelWrapper);
    }

    @Override
    public IChunkWrapper createChunkWrapper(Object[] objectArray) throws ClassCastException {
        if (objectArray.length == 1 && objectArray[0] instanceof IChunkWrapper) {
            try {
                return (IChunkWrapper)objectArray[0];
            }
            catch (Exception e) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
        }
        if (objectArray.length == 2) {
            ILevelWrapper levelWrapper;
            class_1937 level;
            if (!(objectArray[0] instanceof class_2791)) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            class_2791 chunk = (class_2791)objectArray[0];
            if (!(objectArray[1] instanceof class_1937)) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            class_1937 lightSource = level = (class_1937)objectArray[1];
            if (level instanceof class_3218) {
                levelWrapper = ServerLevelWrapper.getWrapper((class_3218)level);
            } else if (level instanceof class_638) {
                levelWrapper = ClientLevelWrapper.getWrapper((class_638)level);
            } else {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            return new ChunkWrapper(chunk, (class_4538)lightSource, levelWrapper);
        }
        throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
    }

    private static String createChunkWrapperErrorMessage(Object[] objectArray) {
        String[] expectedClassNames = new String[]{class_2791.class.getName(), class_3218.class.getName() + "] or [" + class_638.class.getName()};
        return WrapperFactory.createWrapperErrorMessage("Chunk wrapper", expectedClassNames, objectArray);
    }

    @Override
    public IDhApiBiomeWrapper getBiomeWrapper(Object[] objectArray, IDhApiLevelWrapper levelWrapper) {
        if (!(levelWrapper instanceof ILevelWrapper)) {
            throw new ClassCastException("Unable to cast... only DH provided IDhApiLevelWrapper's can be used.");
        }
        ILevelWrapper coreLevelWrapper = (ILevelWrapper)levelWrapper;
        if (!(objectArray[0] instanceof class_6880) || !(((class_6880)objectArray[0]).comp_349() instanceof class_1959)) {
            throw new ClassCastException(WrapperFactory.createBiomeWrapperErrorMessage(objectArray));
        }
        class_6880 biomeHolder = (class_6880)objectArray[0];
        return BiomeWrapper.getBiomeWrapper((class_6880<class_1959>)biomeHolder, coreLevelWrapper);
    }

    private static String createBiomeWrapperErrorMessage(Object[] objectArray) {
        String[] expectedClassNames = new String[]{class_6880.class.getName() + "<" + class_1959.class.getName() + ">"};
        return WrapperFactory.createWrapperErrorMessage("Biome wrapper", expectedClassNames, objectArray);
    }

    @Override
    public IDhApiBlockStateWrapper getBlockStateWrapper(Object[] objectArray, IDhApiLevelWrapper levelWrapper) {
        if (!(levelWrapper instanceof ILevelWrapper)) {
            throw new ClassCastException("Unable to cast... only DH provided IDhApiLevelWrapper's can be used.");
        }
        ILevelWrapper coreLevelWrapper = (ILevelWrapper)levelWrapper;
        if (objectArray.length != 1) {
            throw new ClassCastException(WrapperFactory.createBlockStateWrapperErrorMessage(objectArray));
        }
        if (!(objectArray[0] instanceof class_2680)) {
            throw new ClassCastException(WrapperFactory.createBlockStateWrapperErrorMessage(objectArray));
        }
        class_2680 blockState = (class_2680)objectArray[0];
        return BlockStateWrapper.fromBlockState(blockState, coreLevelWrapper);
    }

    private static String createBlockStateWrapperErrorMessage(Object[] objectArray) {
        String[] expectedClassNames = new String[]{class_6880.class.getName() + "<" + class_1959.class.getName() + ">"};
        return WrapperFactory.createWrapperErrorMessage("BlockState wrapper", expectedClassNames, objectArray);
    }

    private static String createWrapperErrorMessage(String wrapperName, String[] expectedClassNames, Object[] objectArray) {
        StringBuilder message = new StringBuilder(wrapperName + " creation failed. \nExpected object array parameters: \n");
        for (String expectedClassName : expectedClassNames) {
            message.append("[").append(expectedClassName).append("], \n");
        }
        if (objectArray.length != 0) {
            message.append("Given parameters: ");
            for (Object obj : objectArray) {
                String objClassName = obj != null ? obj.getClass().getName() : "NULL";
                message.append("[").append(objClassName).append("], ");
            }
        } else {
            message.append(" No parameters given.");
        }
        return message.toString();
    }
}

