/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBuffer;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBufferBuilder;
import com.seibel.distanthorizons.core.dataObjects.transformers.FullDataToRenderDataTransformer;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.LodQuadTree;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.WillNotClose;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class LodRenderSection
implements IDebugRenderable,
AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final long pos;
    private final IDhClientLevel level;
    @WillNotClose
    private final FullDataSourceProviderV2 fullDataSourceProvider;
    private final LodQuadTree quadTree;
    public boolean renderingEnabled = false;
    private boolean canRender = false;
    public ColumnRenderBuffer renderBuffer;
    private CompletableFuture<Void> uploadRenderDataToGpuFuture = null;
    private final ReentrantLock getRenderSourceLock = new ReentrantLock();
    private ReferencedFutureWrapper renderSourceLoadingRefFuture = null;
    private ReferencedFutureWrapper[] adjacentLoadRefFutures;
    private boolean missingPositionsCalculated = false;
    private LongArrayList missingGenerationPos = null;

    public LodRenderSection(long pos, LodQuadTree quadTree, IDhClientLevel level, FullDataSourceProviderV2 fullDataSourceProvider) {
        this.pos = pos;
        this.quadTree = quadTree;
        this.level = level;
        this.fullDataSourceProvider = fullDataSourceProvider;
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus);
    }

    public synchronized void uploadRenderDataToGpuAsync() {
        if (!GLProxy.hasInstance()) {
            return;
        }
        if (this.uploadRenderDataToGpuFuture != null) {
            return;
        }
        ThreadPoolExecutor executor = ThreadPoolUtil.getFileHandlerExecutor();
        if (executor == null || executor.isTerminated()) {
            return;
        }
        this.uploadRenderDataToGpuFuture = CompletableFuture.runAsync(() -> {
            this.tryDecrementingLoadFutureArray(this.adjacentLoadRefFutures);
            ReferencedFutureWrapper thisLoadFuture = this.getRenderSourceAsync();
            ReferencedFutureWrapper[] adjLoadRefFutures = this.getNeighborRenderSourcesAsync();
            ArrayList<CompletableFuture<ColumnRenderSource>> futureList = new ArrayList<CompletableFuture<ColumnRenderSource>>();
            futureList.add(thisLoadFuture.future);
            for (ReferencedFutureWrapper refFuture : adjLoadRefFutures) {
                futureList.add(refFuture.future);
            }
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).thenAccept(voidObj -> {
                try {
                    ColumnRenderSource renderSource = thisLoadFuture.future.get();
                    if (renderSource == null || renderSource.isEmpty()) {
                        thisLoadFuture.decrementRefCount();
                        for (ReferencedFutureWrapper futureWrapper : adjLoadRefFutures) {
                            futureWrapper.decrementRefCount();
                        }
                        this.canRender = false;
                        this.uploadRenderDataToGpuFuture = null;
                        return;
                    }
                    try {
                        ColumnRenderBuffer previousBuffer = this.renderBuffer;
                        ColumnRenderSource[] adjacentRenderSections = new ColumnRenderSource[EDhDirection.ADJ_DIRECTIONS.length];
                        for (int i = 0; i < EDhDirection.ADJ_DIRECTIONS.length; ++i) {
                            adjacentRenderSections[i] = adjLoadRefFutures[i].future.getNow(null);
                        }
                        ColumnRenderBufferBuilder.buildAndUploadBuffersAsync(this.level, renderSource, adjacentRenderSections).thenAccept(buffer -> {
                            this.renderBuffer = buffer;
                            this.canRender = true;
                            this.uploadRenderDataToGpuFuture = null;
                            if (previousBuffer != null) {
                                previousBuffer.close();
                            }
                            thisLoadFuture.decrementRefCount();
                            this.tryDecrementingLoadFutureArray(adjLoadRefFutures);
                            this.adjacentLoadRefFutures = null;
                        });
                    }
                    catch (Exception e) {
                        thisLoadFuture.decrementRefCount();
                        this.tryDecrementingLoadFutureArray(adjLoadRefFutures);
                        this.adjacentLoadRefFutures = null;
                        LOGGER.error("Unexpected error in LodRenderSection loading, Error: " + e.getMessage(), (Throwable)e);
                        this.uploadRenderDataToGpuFuture = null;
                    }
                }
                catch (Exception e) {
                    thisLoadFuture.decrementRefCount();
                    this.tryDecrementingLoadFutureArray(adjLoadRefFutures);
                    this.adjacentLoadRefFutures = null;
                    LOGGER.error("Unexpected error in LodRenderSection loading, Error: " + e.getMessage(), (Throwable)e);
                    this.uploadRenderDataToGpuFuture = null;
                }
            });
        }, executor);
    }

    private ReferencedFutureWrapper[] getNeighborRenderSourcesAsync() {
        ReferencedFutureWrapper[] futureArray = new ReferencedFutureWrapper[EDhDirection.ADJ_DIRECTIONS.length];
        for (int i = 0; i < EDhDirection.ADJ_DIRECTIONS.length; ++i) {
            EDhDirection direction = EDhDirection.ADJ_DIRECTIONS[i];
            int arrayIndex = direction.ordinal() - 2;
            long adjPos = DhSectionPos.getAdjacentPos(this.pos, direction);
            try {
                LodRenderSection adjRenderSection = (LodRenderSection)this.quadTree.getValue(adjPos);
                if (adjRenderSection != null) {
                    futureArray[arrayIndex] = adjRenderSection.getRenderSourceAsync();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (futureArray[arrayIndex] != null) continue;
            futureArray[arrayIndex] = new ReferencedFutureWrapper(CompletableFuture.completedFuture(null));
        }
        this.adjacentLoadRefFutures = futureArray;
        return futureArray;
    }

    private ReferencedFutureWrapper getRenderSourceAsync() {
        try {
            this.getRenderSourceLock.lock();
            if (this.renderSourceLoadingRefFuture != null) {
                this.renderSourceLoadingRefFuture.incrementRefCount();
                ReferencedFutureWrapper referencedFutureWrapper = this.renderSourceLoadingRefFuture;
                return referencedFutureWrapper;
            }
            ThreadPoolExecutor executor = ThreadPoolUtil.getFileHandlerExecutor();
            if (executor == null || executor.isTerminated()) {
                ReferencedFutureWrapper referencedFutureWrapper = new ReferencedFutureWrapper(CompletableFuture.completedFuture(null));
                return referencedFutureWrapper;
            }
            ReferencedFutureWrapper referencedFutureWrapper = this.renderSourceLoadingRefFuture = new ReferencedFutureWrapper(CompletableFuture.supplyAsync(() -> {
                ColumnRenderSource columnRenderSource;
                block8: {
                    FullDataSourceV2 fullDataSource = (FullDataSourceV2)this.fullDataSourceProvider.get(this.pos);
                    try {
                        ColumnRenderSource renderSource = FullDataToRenderDataTransformer.transformFullDataToRenderSource(fullDataSource, this.level);
                        this.renderSourceLoadingRefFuture = null;
                        columnRenderSource = renderSource;
                        if (fullDataSource == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fullDataSource != null) {
                                try {
                                    fullDataSource.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Unable to get render source " + this.pos + ", error: " + e.getMessage(), (Throwable)e);
                            this.renderSourceLoadingRefFuture = null;
                            return null;
                        }
                    }
                    fullDataSource.close();
                }
                return columnRenderSource;
            }, executor));
            return referencedFutureWrapper;
        }
        finally {
            this.getRenderSourceLock.unlock();
        }
    }

    public boolean canRender() {
        return this.canRender;
    }

    public boolean gpuUploadInProgress() {
        return this.uploadRenderDataToGpuFuture != null;
    }

    public boolean isFullyGenerated() {
        return this.missingPositionsCalculated && this.missingGenerationPos.size() == 0;
    }

    public boolean missingPositionsCalculated() {
        return this.missingPositionsCalculated;
    }

    public int ungeneratedPositionCount() {
        return this.missingGenerationPos != null ? this.missingGenerationPos.size() : 0;
    }

    public void tryQueuingMissingLodRetrieval() {
        if (this.fullDataSourceProvider.canRetrieveMissingDataSources() && this.fullDataSourceProvider.canQueueRetrieval()) {
            if (!this.missingPositionsCalculated) {
                this.missingGenerationPos = this.fullDataSourceProvider.getPositionsToRetrieve(this.pos);
                if (this.missingGenerationPos != null) {
                    this.missingPositionsCalculated = true;
                }
            }
            if (this.missingGenerationPos != null) {
                for (int i = this.missingGenerationPos.size() - 1; i >= 0 && this.fullDataSourceProvider.canQueueRetrieval(); --i) {
                    long pos = this.missingGenerationPos.removeLong(i);
                    boolean positionQueued = this.fullDataSourceProvider.queuePositionForRetrieval(pos);
                    if (positionQueued) continue;
                    this.missingGenerationPos.add(pos);
                    break;
                }
            }
        }
    }

    private void tryDecrementingLoadFutureArray(@Nullable ReferencedFutureWrapper[] refFutures) {
        if (refFutures != null) {
            for (ReferencedFutureWrapper futureWrapper : refFutures) {
                if (futureWrapper == null) continue;
                futureWrapper.decrementRefCount();
            }
        }
    }

    public String toString() {
        return "LodRenderSection{pos=" + this.pos + '}';
    }

    @Override
    public void close() {
        ThreadPoolExecutor executor;
        DebugRenderer.unregister(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus);
        if (Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus.get().booleanValue()) {
            DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(this.pos, 128.0f, 156.0f, 0.09f, Color.RED.darker()), 0.5, 32.0f));
        }
        if (this.renderBuffer != null) {
            this.renderBuffer.close();
        }
        if (this.uploadRenderDataToGpuFuture != null) {
            this.uploadRenderDataToGpuFuture.cancel(true);
        }
        this.tryDecrementingLoadFutureArray(this.adjacentLoadRefFutures);
        if (this.renderSourceLoadingRefFuture != null) {
            this.renderSourceLoadingRefFuture.decrementRefCount();
        }
        if ((executor = ThreadPoolUtil.getCleanupExecutor()) != null && !executor.isTerminated()) {
            try {
                executor.execute(() -> this.fullDataSourceProvider.removeRetrievalRequestIf(genPos -> DhSectionPos.contains(this.pos, genPos)));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @Override
    public void debugRender(DebugRenderer debugRenderer) {
        Color color = Color.red;
        if (this.renderingEnabled) {
            color = Color.green;
        } else if (this.uploadRenderDataToGpuFuture != null) {
            color = Color.yellow;
        } else if (this.canRender) {
            color = Color.cyan;
        }
        debugRenderer.renderBox(new DebugRenderer.Box(this.pos, 400.0f, 8.0f, (Object)Objects.hashCode(this), 0.1f, color));
    }

    private static class ReferencedFutureWrapper {
        public final CompletableFuture<ColumnRenderSource> future;
        private final AtomicInteger refCount = new AtomicInteger(1);

        public ReferencedFutureWrapper(CompletableFuture<ColumnRenderSource> future) {
            this.future = future;
        }

        public void incrementRefCount() {
            this.refCount.incrementAndGet();
        }

        public void decrementRefCount() {
            if (this.refCount.decrementAndGet() <= 0 && this.future != null && !this.future.isDone()) {
                this.future.cancel(true);
            }
        }

        public String toString() {
            return this.future.toString() + " - " + this.refCount.get();
        }
    }
}

