/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiChunkModifiedEvent;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.transformers.ChunkToLodBuilder;
import com.seibel.distanthorizons.core.file.fullDatafile.DelayedFullDataSourceSaveCache;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.sql.dto.ChunkHashDTO;
import com.seibel.distanthorizons.core.sql.repo.ChunkHashRepo;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import java.io.File;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDhLevel
implements IDhLevel {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final ChunkToLodBuilder chunkToLodBuilder;
    @Nullable
    public ChunkHashRepo chunkHashRepo;
    protected final DelayedFullDataSourceSaveCache delayedFullDataSourceSaveCache = new DelayedFullDataSourceSaveCache(this::onDataSourceSave, 2000);
    protected final ConcurrentHashMap<Long, HashSet<DhChunkPos>> updatedChunkPosSetBySectionPos = new ConcurrentHashMap();

    protected AbstractDhLevel() {
        this.chunkToLodBuilder = new ChunkToLodBuilder();
    }

    protected void createAndSetChunkHashRepo(File databaseFile) {
        ChunkHashRepo newChunkHashRepo = null;
        try {
            newChunkHashRepo = new ChunkHashRepo("jdbc:sqlite", databaseFile);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to create [ChunkHashRepo], error: [" + e.getMessage() + "].", (Throwable)e);
        }
        this.chunkHashRepo = newChunkHashRepo;
    }

    @Override
    public int getUnsavedDataSourceCount() {
        return this.delayedFullDataSourceSaveCache.getUnsavedCount();
    }

    @Override
    public void updateChunkAsync(IChunkWrapper chunkWrapper) {
        FullDataSourceV2 dataSource = FullDataSourceV2.createFromChunk(chunkWrapper);
        if (dataSource == null) {
            return;
        }
        this.updatedChunkPosSetBySectionPos.compute(dataSource.getPos(), (dataSourcePos, chunkPosSet) -> {
            if (chunkPosSet == null) {
                chunkPosSet = new HashSet<DhChunkPos>();
            }
            chunkPosSet.add(chunkWrapper.getChunkPos());
            return chunkPosSet;
        });
        this.delayedFullDataSourceSaveCache.queueDataSourceForUpdateAndSave(dataSource);
    }

    private void onDataSourceSave(FullDataSourceV2 fullDataSource) {
        this.updateDataSourcesAsync(fullDataSource).thenRun(() -> {
            HashSet<DhChunkPos> updatedChunkPosSet = this.updatedChunkPosSetBySectionPos.remove(fullDataSource.getPos());
            if (updatedChunkPosSet != null) {
                for (DhChunkPos chunkPos : updatedChunkPosSet) {
                    ApiEventInjector.INSTANCE.fireAllEvents(DhApiChunkModifiedEvent.class, new DhApiChunkModifiedEvent.EventParam(this.getLevelWrapper(), chunkPos.x, chunkPos.z));
                }
            }
        });
    }

    @Override
    public int getChunkHash(DhChunkPos pos) {
        if (this.chunkHashRepo == null) {
            return 0;
        }
        ChunkHashDTO dto = (ChunkHashDTO)this.chunkHashRepo.getByKey(pos);
        return dto != null ? dto.chunkHash : 0;
    }

    @Override
    public void setChunkHash(DhChunkPos pos, int chunkHash) {
        if (this.chunkHashRepo != null) {
            this.chunkHashRepo.save(new ChunkHashDTO(pos, chunkHash));
        }
    }

    @Override
    public void close() {
        this.chunkToLodBuilder.close();
    }
}

