/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData.sources;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.IDataSource;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV1DTO;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.io.IOException;
import java.util.Arrays;
import org.apache.logging.log4j.Logger;

public class FullDataSourceV1
implements IDataSource<IDhLevel> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final byte SECTION_SIZE_OFFSET = 6;
    public static final int WIDTH = BitShiftUtil.powerOfTwo(6);
    public static final byte DATA_FORMAT_VERSION = 3;
    public static final String DATA_TYPE_NAME = "CompleteFullDataSource";
    private static final int DATA_GUARD_BYTE = -1;
    private static final int NO_DATA_FLAG_BYTE = 1;
    public final FullDataPointIdMap mapping;
    public EDhApiWorldGenerationStep worldGenStep = EDhApiWorldGenerationStep.EMPTY;
    private final long[][] dataArrays = new long[WIDTH * WIDTH][0];
    private long pos;
    private boolean isEmpty = true;

    public static FullDataSourceV1 createEmpty(long pos) {
        return new FullDataSourceV1(pos);
    }

    private FullDataSourceV1(long pos) {
        this.mapping = new FullDataPointIdMap(pos);
        this.pos = pos;
    }

    @Override
    @Deprecated
    public boolean update(FullDataSourceV2 dataSource, IDhLevel level) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Override
    public Long getKey() {
        return this.pos;
    }

    @Override
    public String getKeyDisplayString() {
        return DhSectionPos.toString(this.pos);
    }

    @Override
    public Long getPos() {
        return this.pos;
    }

    public void resizeDataStructuresForRepopulation(long pos) {
        this.pos = pos;
    }

    @Override
    public byte getDataDetailLevel() {
        return (byte)(DhSectionPos.getDetailLevel(this.pos) - 6);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public long[] get(int index) {
        return this.get(index / WIDTH, index % WIDTH);
    }

    public long[] get(int relativeX, int relativeZ) {
        int dataArrayIndex = relativeX * WIDTH + relativeZ;
        if (dataArrayIndex >= this.dataArrays.length) {
            LodUtil.assertNotReach("FullDataArrayAccessor.get() called with a relative position that is outside the data source. \ngiven relative pos X: [" + relativeX + "] Z: [" + relativeZ + "]\ndataArrays.length: [" + this.dataArrays.length + "] dataArrayIndex: [" + dataArrayIndex + "].");
        }
        return this.dataArrays[dataArrayIndex];
    }

    public void repopulateFromStream(FullDataSourceV1DTO dto, DhDataInputStream inputStream, IDhLevel level) throws IOException, InterruptedException, DataCorruptedException {
        this.resizeDataStructuresForRepopulation(dto.pos);
        this.mapping.clear(dto.pos);
        this.populateFromStream(dto, inputStream, level);
    }

    public void populateFromStream(FullDataSourceV1DTO dto, DhDataInputStream inputStream, IDhLevel level) throws IOException, InterruptedException, DataCorruptedException {
        FullDataSourceSummaryData summaryData = this.readSourceSummaryInfo(dto, inputStream, level);
        this.setSourceSummaryData(summaryData);
        long[][] dataPoints = this.readDataPoints(summaryData.dataWidth, inputStream);
        if (dataPoints == null) {
            return;
        }
        this.setDataPoints(dataPoints);
        FullDataPointIdMap mapping = this.readIdMappings(inputStream, level.getLevelWrapper());
        this.setIdMapping(mapping);
    }

    @Deprecated
    public void writeSourceSummaryInfo(IDhLevel level, DhDataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.getDataDetailLevel());
        outputStream.writeInt(WIDTH);
        outputStream.writeInt(level.getMinY());
        outputStream.writeByte(this.worldGenStep.value);
    }

    public FullDataSourceSummaryData readSourceSummaryInfo(FullDataSourceV1DTO dto, DhDataInputStream inputStream, IDhLevel level) throws IOException {
        byte worldGenByte;
        EDhApiWorldGenerationStep worldGenStep;
        int dataDetail = inputStream.readInt();
        if (dataDetail != dto.dataDetailLevel) {
            throw new IOException(LodUtil.formatLog("Data level mismatch. Expected: [" + dto.dataDetailLevel + "], found [" + dataDetail + "].", new Object[0]));
        }
        int width = inputStream.readInt();
        if (width != WIDTH) {
            throw new IOException(LodUtil.formatLog("Section width mismatch: " + width + " != " + WIDTH + " (Currently only 1 section width is supported)", new Object[0]));
        }
        int minY = inputStream.readInt();
        if (minY != level.getMinY()) {
            LOGGER.warn("Data minY mismatch: " + minY + " != " + level.getMinY() + ". Will ignore data's y level");
        }
        if ((worldGenStep = EDhApiWorldGenerationStep.fromValue(worldGenByte = inputStream.readByte())) == null) {
            worldGenStep = EDhApiWorldGenerationStep.SURFACE;
            LOGGER.warn("Missing WorldGenStep, defaulting to: " + worldGenStep.name());
        }
        return new FullDataSourceSummaryData(width, worldGenStep);
    }

    public void setSourceSummaryData(FullDataSourceSummaryData summaryData) {
        this.worldGenStep = summaryData.worldGenStep;
    }

    @Deprecated
    public boolean writeDataPoints(DhDataOutputStream outputStream) throws IOException {
        int z;
        int x;
        if (this.isEmpty()) {
            outputStream.writeInt(1);
            return false;
        }
        outputStream.writeInt(-1);
        for (x = 0; x < WIDTH; ++x) {
            for (z = 0; z < WIDTH; ++z) {
                outputStream.writeInt(this.get(x, z).length);
            }
        }
        outputStream.writeInt(-1);
        for (x = 0; x < WIDTH; ++x) {
            for (z = 0; z < WIDTH; ++z) {
                long[] dataColumn = this.get(x, z);
                if (dataColumn == null) continue;
                for (long dataPoint : dataColumn) {
                    outputStream.writeLong(dataPoint);
                }
            }
        }
        return true;
    }

    public long[][] readDataPoints(int width, DhDataInputStream dataInputStream) throws IOException {
        int dataPresentFlag = dataInputStream.readInt();
        if (dataPresentFlag == 1) {
            return null;
        }
        if (dataPresentFlag != -1) {
            throw new IOException("Invalid file format. Data Points guard byte expected: (no data) [1] or (data present) [-1], but found [" + dataPresentFlag + "].");
        }
        Object dataPointArrays = WIDTH == width ? this.dataArrays : (Object)new long[width * width][];
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                int requestedArrayLength = dataInputStream.readInt();
                int arrayIndex = x * width + z;
                if (dataPointArrays[arrayIndex] == null || dataPointArrays[arrayIndex].length != requestedArrayLength) {
                    dataPointArrays[arrayIndex] = new long[requestedArrayLength];
                    continue;
                }
                Arrays.fill(dataPointArrays[arrayIndex], 0L);
            }
        }
        int arrayStartFlag = dataInputStream.readInt();
        if (arrayStartFlag != -1) {
            throw new IOException("invalid data length end guard");
        }
        for (int xz = 0; xz < ((long[][])dataPointArrays).length; ++xz) {
            if (dataPointArrays[xz].length == 0) continue;
            for (int y = 0; y < dataPointArrays[xz].length; ++y) {
                dataPointArrays[xz][y] = dataInputStream.readLong();
            }
        }
        return dataPointArrays;
    }

    public void setDataPoints(long[][] dataPoints) {
        LodUtil.assertTrue(this.dataArrays.length == dataPoints.length, "Data point array length mismatch.");
        this.isEmpty = false;
        System.arraycopy(dataPoints, 0, this.dataArrays, 0, dataPoints.length);
    }

    @Deprecated
    public void writeIdMappings(DhDataOutputStream outputStream) throws IOException {
        outputStream.writeInt(-1);
        this.mapping.serialize(outputStream);
    }

    public FullDataPointIdMap readIdMappings(DhDataInputStream inputStream, ILevelWrapper levelWrapper) throws IOException, InterruptedException, DataCorruptedException {
        int guardByte = inputStream.readInt();
        if (guardByte != -1) {
            throw new IOException("Invalid data content end guard for ID mapping");
        }
        return FullDataPointIdMap.deserialize(inputStream, this.pos, levelWrapper);
    }

    public void setIdMapping(FullDataPointIdMap mappings) {
        this.mapping.mergeAndReturnRemappedEntityIds(mappings);
    }

    @Override
    public void close() throws Exception {
    }

    private static class FullDataSourceSummaryData {
        public final int dataWidth;
        public EDhApiWorldGenerationStep worldGenStep;

        public FullDataSourceSummaryData(int dataWidth, EDhApiWorldGenerationStep worldGenStep) {
            this.dataWidth = dataWidth;
            this.worldGenStep = worldGenStep;
        }
    }
}

