/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;

public class LocatedHandlerRegistry<T> {
    private final HashMap<class_2960, T> handlers = new LinkedHashMap<class_2960, T>();
    private final HashMap<T, class_2960> handlersInv = new LinkedHashMap<T, class_2960>();
    private T defaultHandler;
    private boolean allowOverwrite = false;

    public LocatedHandlerRegistry(T handler) {
        this.defaultHandler = handler;
    }

    public LocatedHandlerRegistry<T> allowOverwrite() {
        this.allowOverwrite = true;
        return this;
    }

    public T getDefault() {
        return this.defaultHandler;
    }

    public void register(class_2960 id, T handler) {
        if (!this.allowOverwrite && this.handlers.containsKey(id)) {
            throw new IllegalArgumentException("'" + String.valueOf(id) + "' already exists");
        }
        this.handlers.put(id, handler);
        this.handlersInv.put(handler, id);
    }

    public void registerDefault(class_2960 id, T handler) {
        this.defaultHandler = handler;
        this.register(id, handler);
    }

    public class_2960 getLocation(T type) {
        return this.handlersInv.get(type);
    }

    public T get(class_2960 id) {
        return this.handlers.getOrDefault(id, this.defaultHandler);
    }

    public T getOrThrow(class_2960 id) {
        T handler = this.handlers.get(id);
        if (handler == null) {
            throw new IllegalArgumentException("'" + String.valueOf(id) + "' does not exist");
        }
        return handler;
    }

    public boolean contains(class_2960 id) {
        return this.handlers.containsKey(id);
    }

    public Collection<class_2960> keys() {
        return this.handlers.keySet();
    }

    public Set<Map.Entry<class_2960, T>> entrySet() {
        return this.handlers.entrySet();
    }

    public Collection<T> values() {
        return this.handlers.values();
    }
}

