/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiControlClickEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiEventManager;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.type.itr.ConsecutiveIterator;

public class GuiParent
extends GuiControl
implements IGuiParent,
Iterable<GuiChildControl> {
    private GuiEventManager eventManager;
    protected List<GuiChildControl> controls = new CopyOnWriteArrayList<GuiChildControl>();
    protected List<GuiChildControl> hoverControls = new CopyOnWriteArrayList<GuiChildControl>();
    public GuiFlow flow;
    public Align align = Align.LEFT;
    public VAlign valign = VAlign.TOP;
    public int spacing = 2;
    private double scale = 1.0;
    private double scaleInv = 1.0;

    public GuiParent(String name, GuiFlow flow) {
        super(name);
        this.flow = flow;
    }

    public GuiParent(String name, GuiFlow flow, VAlign valign) {
        this(name, flow, Align.LEFT, valign);
    }

    public GuiParent(String name, GuiFlow flow, Align align) {
        this(name, flow, align, VAlign.TOP);
    }

    public GuiParent(String name, GuiFlow flow, Align align, VAlign valign) {
        this(name, flow);
        this.align = align;
        this.valign = valign;
    }

    public GuiParent(String name) {
        this(name, GuiFlow.STACK_X);
    }

    public GuiParent() {
        this("");
    }

    public GuiParent(GuiFlow flow) {
        this("", flow);
    }

    @Override
    public boolean isClient() {
        return this.getParent().isClient();
    }

    public GuiParent setScale(double scale) {
        this.scale = scale;
        this.scaleInv = 1.0 / scale;
        return this;
    }

    public final double scaleFactor() {
        return this.scale;
    }

    public final double scaleFactorInv() {
        return this.scaleInv;
    }

    public double getOffsetY() {
        return 0.0;
    }

    public double getOffsetX() {
        return 0.0;
    }

    public GuiParent setAlign(Align align) {
        this.align = align;
        return this;
    }

    public GuiParent setVAlign(VAlign valign) {
        this.valign = valign;
        return this;
    }

    public GuiParent setSpacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public GuiParent setFlow(GuiFlow flow) {
        this.flow = flow;
        return this;
    }

    @Override
    public boolean isExpandableX() {
        if (super.isExpandableX()) {
            return true;
        }
        for (GuiChildControl child : this.controls) {
            if (!child.control.isExpandableX()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExpandableY() {
        if (super.isExpandableY()) {
            return true;
        }
        for (GuiChildControl child : this.controls) {
            if (!child.control.isExpandableY()) continue;
            return true;
        }
        return false;
    }

    private static GuiControl get(String name, List<GuiChildControl> collection) {
        for (int i = 0; i < collection.size(); ++i) {
            GuiControl control = collection.get((int)i).control;
            if (control.name.equalsIgnoreCase(name)) {
                return control;
            }
            if (!(control instanceof GuiParent)) continue;
            GuiParent parent = (GuiParent)control;
            if (control.name.isBlank()) {
                Object result = parent.get(name);
                if (result == null) continue;
                return result;
            }
            if (!name.startsWith(control.name + ".")) continue;
            return parent.get(name.substring(control.name.length() + 1));
        }
        return null;
    }

    public <T extends GuiControl> T get(String name) {
        if (name.isBlank()) {
            return (T)this;
        }
        GuiControl result = GuiParent.get(name, this.controls);
        if (result != null) {
            return (T)result;
        }
        return (T)GuiParent.get(name, this.hoverControls);
    }

    public <T extends GuiControl> T get(String name, Class<T> clazz) {
        T result = this.get(name);
        if (clazz.isInstance(result)) {
            return result;
        }
        return null;
    }

    public boolean has(String name) {
        return this.get(name) != null;
    }

    public GuiChildControl addControl(GuiControl control) {
        control.setParent(this);
        GuiChildControl child = new GuiChildControl(control);
        this.controls.add(child);
        return child;
    }

    public GuiParent add(GuiControl control) {
        this.addControl(control);
        return this;
    }

    public GuiParent add(GuiControl ... controls) {
        for (GuiControl c : controls) {
            this.addControl(c);
        }
        return this;
    }

    public GuiParent add(boolean conditional, Supplier<GuiControl> controlSupplier) {
        if (conditional) {
            return this.add(controlSupplier.get());
        }
        return this;
    }

    public GuiChildControl addHoverControl(GuiControl control) {
        control.setParent(this);
        GuiChildControl child = new GuiChildControl(control);
        this.hoverControls.add(child);
        return child;
    }

    public GuiParent addHover(GuiControl control) {
        this.addHoverControl(control);
        return this;
    }

    public GuiParent addHover(GuiControl ... controls) {
        for (GuiControl c : controls) {
            this.addHoverControl(c);
        }
        return this;
    }

    public GuiParent addHover(boolean conditional, Supplier<GuiControl> controlSupplier) {
        if (conditional) {
            return this.addHover(controlSupplier.get());
        }
        return this;
    }

    public boolean remove(GuiChildControl control) {
        return this.controls.remove(control) || this.hoverControls.remove(control);
    }

    public GuiChildControl find(GuiControl control) {
        for (GuiChildControl child : this.controls) {
            if (child.control != control) continue;
            return child;
        }
        for (GuiChildControl child : this.hoverControls) {
            if (child.control != control) continue;
            return child;
        }
        return null;
    }

    public GuiChildControl replace(GuiControl oldControl, GuiControl newControl) {
        int i;
        for (i = 0; i < this.controls.size(); ++i) {
            if (this.controls.get((int)i).control != oldControl) continue;
            GuiChildControl child = new GuiChildControl(newControl);
            this.controls.set(i, child);
            return child;
        }
        for (i = 0; i < this.hoverControls.size(); ++i) {
            if (this.hoverControls.get((int)i).control != oldControl) continue;
            GuiChildControl child = new GuiChildControl(newControl);
            this.hoverControls.set(i, child);
            return child;
        }
        return null;
    }

    public GuiChildControl remove(GuiControl control) {
        GuiChildControl child;
        int i;
        for (i = 0; i < this.controls.size(); ++i) {
            child = this.controls.get(i);
            if (child.control != control) continue;
            this.controls.remove(i);
            return child;
        }
        for (i = 0; i < this.hoverControls.size(); ++i) {
            child = this.hoverControls.get(i);
            if (child.control != control) continue;
            this.hoverControls.remove(i);
            return child;
        }
        return null;
    }

    public void remove(String ... include) {
        this.controls.removeIf(x -> ArrayUtils.contains((Object[])include, (Object)x.control.name));
        this.hoverControls.removeIf(x -> ArrayUtils.contains((Object[])include, (Object)x.control.name));
    }

    public void removeExclude(String ... exclude) {
        this.controls.removeIf(x -> !ArrayUtils.contains((Object[])exclude, (Object)x.control.name));
        this.hoverControls.removeIf(x -> !ArrayUtils.contains((Object[])exclude, (Object)x.control.name));
    }

    public boolean isEmpty() {
        return this.controls.isEmpty() && this.hoverControls.isEmpty();
    }

    public void clear() {
        this.controls.clear();
        this.hoverControls.clear();
    }

    public int size() {
        return this.controls.size() + this.hoverControls.size();
    }

    @Override
    public Iterator<GuiChildControl> iterator() {
        if (this.hoverControls.isEmpty()) {
            return this.controls.iterator();
        }
        return new ConsecutiveIterator<GuiChildControl>(this.hoverControls, this.controls);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderControls(class_332 graphics, Rect contentRect, Rect realContentRect, int mouseX, int mouseY, ListIterator<GuiChildControl> collection, double scale, double xOffset, double yOffset, boolean hover) {
        class_4587 pose = graphics.method_51448();
        while (collection.hasPrevious()) {
            Rect controlRect;
            Rect realRect;
            GuiChildControl child = collection.previous();
            GuiControl control = child.control;
            if (!control.visible || (realRect = realContentRect.intersection(controlRect = control.createChildRect(child, contentRect, scale, xOffset, yOffset))) == null && !hover) continue;
            if (hover) {
                RenderSystem.disableScissor();
            } else {
                realRect.scissor();
            }
            pose.method_22903();
            pose.method_22904((double)child.getX() + xOffset, (double)child.getY() + yOffset, 10.0);
            this.renderControl(graphics, child, control, controlRect, realRect, scale, mouseX, mouseY, hover);
            pose.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderControl(class_332 graphics, GuiChildControl child, GuiControl control, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY, boolean hover) {
        control.render(graphics, child, controlRect, hover ? controlRect : realRect, scale, mouseX, mouseY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void renderContent(class_332 graphics, GuiChildControl control, Rect contentRect, Rect realContentRect, double scale, int mouseX, int mouseY) {
        if (realContentRect == null) {
            return;
        }
        class_4587 pose = graphics.method_51448();
        float controlScale = (float)this.scaleFactor();
        double xOffset = this.getOffsetX();
        double yOffset = this.getOffsetY();
        pose.method_22905(controlScale, controlScale, 1.0f);
        this.renderControls(graphics, contentRect, realContentRect, mouseX, mouseY, this.controls.listIterator(this.controls.size()), scale *= this.scaleFactor(), xOffset, yOffset, false);
        this.renderControls(graphics, contentRect, realContentRect, mouseX, mouseY, this.hoverControls.listIterator(this.hoverControls.size()), scale, xOffset, yOffset, true);
        super.renderContent(graphics, control, contentRect, realContentRect, scale, mouseX, mouseY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void renderContent(class_332 graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
    }

    @Override
    public boolean isContainer() {
        return this.getParent().isContainer();
    }

    @Override
    public void init() {
        for (GuiChildControl child : this) {
            child.control.init();
        }
    }

    @Override
    public void closed() {
        for (GuiChildControl child : this) {
            child.control.closed();
        }
    }

    @Override
    public void tick() {
        for (GuiChildControl child : this) {
            child.control.tick();
        }
    }

    @Override
    public void closeTopLayer() {
        this.getParent().closeTopLayer();
    }

    public void closeThisLayer() {
        this.getParent().closeLayer(this.getLayer());
    }

    @Override
    public void closeLayer(GuiLayer layer) {
        this.getParent().closeLayer(layer);
    }

    public boolean isMouseOverHovered(double x, double y) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this.hoverControls) {
            if (!child.isMouseOver(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rect toLayerRect(GuiControl control, Rect rect) {
        GuiChildControl child = this.find(control);
        if (child == null) {
            return rect;
        }
        rect.move(child.rect.minX + this.getOffsetX() + (double)this.getContentOffset(), child.rect.minY + this.getOffsetY() + (double)this.getContentOffset());
        rect.scale(this.scaleFactor());
        return this.getParent().toLayerRect(this, rect);
    }

    @Override
    public Rect toScreenRect(GuiControl control, Rect rect) {
        GuiChildControl child = this.find(control);
        if (child == null) {
            return rect;
        }
        rect.move(child.rect.minX + this.getOffsetX() + (double)this.getContentOffset(), child.rect.minY + this.getOffsetY() + (double)this.getContentOffset());
        rect.scale(this.scaleFactor());
        return this.getParent().toScreenRect(this, rect);
    }

    @Override
    public GuiTooltipEvent getTooltipEvent(Rect rect, double x, double y) {
        GuiTooltipEvent event = super.getTooltipEvent(rect, x, y);
        if (event != null) {
            return event;
        }
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.isMouseOver(x, y) || (event = child.control.getTooltipEvent(child.rect, x - (double)child.getX(), y - (double)child.getY())) == null) continue;
            return event;
        }
        return null;
    }

    @Override
    public boolean testForDoubleClick(Rect rect, double x, double y, int button) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.rect.inside(x, y) || !child.control.testForDoubleClick(child.rect, x - (double)child.getX(), y - (double)child.getY(), button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable()) continue;
            child.control.mouseMoved(child.rect, x - (double)child.getX(), y - (double)child.getY());
        }
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        boolean result = false;
        for (GuiChildControl child : this) {
            if (!result && child.control.isInteractable() && child.isMouseOver(x, y) && child.control.mouseClicked(child.rect, x - (double)child.getX(), y - (double)child.getY(), button)) {
                this.raiseEvent(new GuiControlClickEvent(child.control, button, false));
                result = true;
                continue;
            }
            child.control.looseFocus();
        }
        return result;
    }

    @Override
    public boolean mouseDoubleClicked(Rect rect, double x, double y, int button) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        boolean result = false;
        for (GuiChildControl child : this) {
            if (!result && child.control.isInteractable() && child.isMouseOver(x, y) && child.control.mouseDoubleClicked(child.rect, x - (double)child.getX(), y - (double)child.getY(), button)) {
                this.raiseEvent(new GuiControlClickEvent(child.control, button, false));
                result = true;
                continue;
            }
            child.control.looseFocus();
        }
        return result;
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable()) continue;
            child.control.mouseReleased(child.rect, x - (double)child.getX(), y - (double)child.getY(), button);
        }
    }

    @Override
    public void mouseDragged(Rect rect, double x, double y, int button, double dragX, double dragY, double time) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable()) continue;
            child.control.mouseDragged(child.rect, x - (double)child.getX(), y - (double)child.getY(), button, dragX, dragY, time);
        }
    }

    @Override
    public boolean mouseScrolled(Rect rect, double x, double y, double delta) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.isMouseOver(x, y) || !child.control.mouseScrolled(child.rect, x - (double)child.getX(), y - (double)child.getY(), delta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.control.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.control.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.control.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void looseFocus() {
        for (GuiChildControl child : this) {
            child.control.looseFocus();
        }
    }

    @Override
    public void raiseEvent(GuiEvent event) {
        if (this.getParent() == null) {
            return;
        }
        if (this.eventManager != null) {
            this.eventManager.raiseEvent(event);
        }
        if (!event.isCanceled()) {
            this.getParent().raiseEvent(event);
        }
    }

    public void registerEventClick(Consumer<GuiControlClickEvent> consumer) {
        this.registerEvent(GuiControlClickEvent.class, consumer);
    }

    public void registerEventChanged(Consumer<GuiControlChangedEvent> consumer) {
        this.registerEvent(GuiControlChangedEvent.class, consumer);
    }

    public <T extends GuiEvent> void registerEvent(Class<T> clazz, Consumer<T> action) {
        if (this.eventManager == null) {
            this.eventManager = new GuiEventManager();
        }
        this.eventManager.registerEvent(clazz, action);
    }

    public void clearEvents() {
        if (this.eventManager != null) {
            this.eventManager.clear();
        }
    }

    @Override
    public String getNestedName() {
        if (this.name.isBlank()) {
            if (this.getParent() instanceof GuiControl) {
                return ((GuiControl)((Object)this.getParent())).getNestedName();
            }
            return "";
        }
        return super.getNestedName();
    }

    @Override
    public void flowX(int width, int preferred) {
        this.flow.flowX(this.controls, this.spacing, this.align, width, preferred, this.endlessX());
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        this.flow.flowY(this.controls, this.spacing, this.valign, width, height, preferred, this.endlessY());
    }

    protected boolean endlessX() {
        return false;
    }

    protected boolean endlessY() {
        return false;
    }

    @Override
    protected int minWidth(int availableWidth) {
        return this.flow.minWidth(this.controls, this.spacing, availableWidth);
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return this.flow.preferredWidth(this.controls, this.spacing, availableWidth);
    }

    @Override
    protected int minHeight(int width, int availableHeight) {
        return this.flow.minHeight(this.controls, this.spacing, width, availableHeight);
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return this.flow.preferredHeight(this.controls, this.spacing, width, availableHeight);
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }
}

