/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.sync;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.event.ConfigEventHandler;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.sync.ConfigurationPacket;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.type.tree.CheckTree;

public class ConfigurationClientPacket
extends CreativePacket {
    public String[] path;
    public List<String> enabled;

    public ConfigurationClientPacket(ICreativeConfigHolder holder, CheckTree<ConfigKey> tree) {
        this.path = holder.path();
        this.enabled = this.buildClientFieldList(tree.root, new ArrayList<String>());
    }

    public ConfigurationClientPacket(ICreativeConfigHolder holder) {
        this.path = holder.path();
        this.enabled = ConfigEventHandler.loadClientFieldList(holder);
    }

    public List<String> buildClientFieldList(CheckTree.CheckTreeEntry entry, List<String> list) {
        if (entry.isEnabled() && entry.content != null) {
            Object path = entry.parent != null && entry.parent.content != null ? String.join((CharSequence)".", ((ICreativeConfigHolder)((ConfigKey)entry.parent.content).get()).path()) + "." : "";
            list.add((String)path + ((ConfigKey)entry.content).name);
            return list;
        }
        if (entry.children != null) {
            for (CheckTree.CheckTreeEntry child : entry.children) {
                this.buildClientFieldList(child, list);
            }
        }
        return list;
    }

    public ConfigurationClientPacket() {
    }

    public ICreativeConfigHolder run() {
        ICreativeConfigHolder holder = CreativeConfigRegistry.ROOT.followPath(this.path);
        if (holder != null) {
            ConfigEventHandler.saveClientFieldList(holder, this.enabled);
        }
        return holder;
    }

    @Override
    public void executeClient(class_1657 player) {
        this.run();
        ConfigurationPacket.updateGui(player);
    }

    @Override
    public void executeServer(class_3222 player) {
        CreativeCore.NETWORK.sendToClientAll(player.method_5682(), new ConfigurationClientPacket(this.run()));
        CreativeCore.CONFIG_HANDLER.saveClientFields();
        CreativeCore.CONFIG_HANDLER.save((class_7225.class_7874)player.method_56673(), Side.SERVER);
    }
}

