/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_757;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class GuiRenderHelper {
    private static final class_310 mc = class_310.method_1551();

    public static class_327 getFont() {
        return GuiRenderHelper.mc.field_1772;
    }

    public static void drawItemStack(class_4587 mat, class_1799 stack, float alpha) {
        boolean flag;
        class_918 renderer = mc.method_1480();
        mc.method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        matrix.mul((Matrix4fc)mat.method_23760().method_23761());
        matrix.translate(0.0f, 0.0f, 100.0f);
        matrix.translate(8.0f, 8.0f, 8.0f);
        matrix.mul((Matrix4fc)new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        matrix.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 multibuffersource$buffersource = class_310.method_1551().method_22940().method_23000();
        class_1087 bakedmodel = renderer.method_4019(stack, null, null, 0);
        boolean bl = flag = !bakedmodel.method_24304();
        if (flag) {
            class_308.method_24210();
        }
        renderer.method_23179(stack, class_811.field_4317, false, new class_4587(), (class_4597)multibuffersource$buffersource, 0xF000F0, class_4608.field_21444, bakedmodel);
        multibuffersource$buffersource.method_22993();
        RenderSystem.enableDepthTest();
        if (flag) {
            class_308.method_24211();
        }
        matrix.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawStringCentered(class_332 graphics, String text, float width, float height, int color, boolean shadow) {
        int dotWith;
        int textWidth = GuiRenderHelper.mc.field_1772.method_1727((String)text);
        if ((float)textWidth > width && textWidth > (dotWith = GuiRenderHelper.mc.field_1772.method_1727("..."))) {
            int charWidth;
            StringBuilder builder = new StringBuilder();
            textWidth = 0;
            for (int i = 0; i < ((String)text).length() && (float)((charWidth = GuiRenderHelper.mc.field_1772.method_1727("" + ((String)text).charAt(i))) + textWidth + dotWith) < width; ++i) {
                builder.append(((String)text).charAt(i));
                textWidth += charWidth;
            }
            text = String.valueOf(builder) + "...";
        }
        class_327 class_3272 = GuiRenderHelper.mc.field_1772;
        float f = width / 2.0f - (float)(GuiRenderHelper.mc.field_1772.method_1727((String)text) / 2);
        float f2 = height / 2.0f;
        Objects.requireNonNull(GuiRenderHelper.mc.field_1772);
        class_3272.method_27521((String)text, f, f2 - (float)(9 / 2), -1, shadow, graphics.method_51448().method_23760().method_23761(), (class_4597)graphics.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public static void horizontalGradientRect(class_332 graphics, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        class_4588 consumer = graphics.method_51450().getBuffer(class_1921.method_51784());
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        boolean z = false;
        consumer.method_22918(matrix, (float)x2, (float)y, (float)z).method_39415(colorTo);
        consumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(colorFrom);
        consumer.method_22918(matrix, (float)x, (float)y2, (float)z).method_39415(colorFrom);
        consumer.method_22918(matrix, (float)x2, (float)y2, (float)z).method_39415(colorTo);
    }

    public static void verticalGradientRect(class_332 graphics, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        class_4588 consumer = graphics.method_51450().getBuffer(class_1921.method_51784());
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        boolean z = false;
        consumer.method_22918(matrix, (float)x2, (float)y, (float)z).method_39415(colorFrom);
        consumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(colorFrom);
        consumer.method_22918(matrix, (float)x, (float)y2, (float)z).method_39415(colorTo);
        consumer.method_22918(matrix, (float)x2, (float)y2, (float)z).method_39415(colorTo);
    }

    public static void horizontalGradientMaskRect(class_332 graphics, int x, int y, int x2, int y2, int color, int mask) {
        GuiRenderHelper.horizontalGradientRect(graphics, x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    public static void colorRect(class_332 graphics, int x, int y, int width, int height, int color) {
        class_4588 consumer = graphics.method_51450().getBuffer(class_1921.method_51784());
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        boolean z = false;
        consumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(color);
        consumer.method_22918(matrix, (float)x, (float)(y + height), (float)z).method_39415(color);
        consumer.method_22918(matrix, (float)(x + width), (float)(y + height), (float)z).method_39415(color);
        consumer.method_22918(matrix, (float)(x + width), (float)y, (float)z).method_39415(color);
    }

    private static void textureRect(class_332 graphics, int x, int y, int z, int width, int height, float u, float v, int textureWidth, int textureHeight) {
        GuiRenderHelper.textureRect(graphics, x, x + width, y, y + height, z, u, v, width, height, textureWidth, textureHeight);
    }

    public static void textureRect(class_332 graphics, int x, int y, int width, int height, float u, float v) {
        GuiRenderHelper.textureRect(graphics, x, y, 0, width, height, u, v, 256, 256);
    }

    public static void textureRect(class_332 graphics, int x, int y, int width, int height, float u, float v, float u2, float v2) {
        GuiRenderHelper.textureRect(graphics, x, x + width, y, y + height, 0, u, v, u2, v2, 256, 256);
    }

    private static void textureRect(class_332 graphics, int x, int x2, int y, int y2, int z, float u, float v, float u2, float v2, int textureWidth, int textureHeight) {
        GuiRenderHelper.drawTextureRect(graphics, x, x2, y, y2, z, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight);
    }

    private static void textureRect(class_332 graphics, int x, int x2, int y, int y2, int z, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        GuiRenderHelper.drawTextureRect(graphics, x, x2, y, y2, z, u / (float)textureWidth, (u + (float)uWidth) / (float)textureWidth, v / (float)textureHeight, (v + (float)vHeight) / (float)textureHeight);
    }

    private static void drawTextureRect(class_332 graphics, int x, int x2, int y, int y2, int z, float u, float u2, float v, float v2) {
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferbuilder.method_22918(matrix, (float)x, (float)y2, (float)z).method_22913(u, v2);
        bufferbuilder.method_22918(matrix, (float)x2, (float)y2, (float)z).method_22913(u2, v2);
        bufferbuilder.method_22918(matrix, (float)x2, (float)y, (float)z).method_22913(u2, v);
        bufferbuilder.method_22918(matrix, (float)x, (float)y, (float)z).method_22913(u, v);
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
    }
}

