<?php
/*
abstract class Employee {
  protected $name;
  private static $types = array('Builder','Manager','Chief');
  function __construct( $name ){
    $this->name = $name;
  }
  
  static function recruit ( $type, $name  ){
    if ( in_array($type, $this->types) )
	  return new $type( $name );
  }
  
  abstract function work(); 
}

class Builder extends Employee {
  function work(){
    echo $this->name," строитель";
  }
}
class Manager extends Employee {
  function work(){
    echo $this->name," менеджер";
  }
}
class Chief extends Employee {
  function work(){
    echo $this->name," руководитель";
  }
}

class NastyBoss {
  private $employees = array();
  
  function addEmployee( Employee $employee ){
    $this->employees[] = $employee;
  }
  
  function projectFails() {
    if ( count( $this->employees ) > 0 ){
	  $emp = array_pop( $this->employees );
	  $emp->work();
	}
  }
}

$boss = new NastyBoss;
$boss->addEmployee( new Builder( "Василий" ) );
$boss->addEmployee( new Manager( "Петр" ) );
$boss->addEmployee( new Chief( "Федор" ) );
$boss->projectFails();
$boss->projectFails();
$boss->projectFails();*/



abstract class Employee {
  protected $name;
  private static $types = array('Builder','Manager','Chief');
  function __construct( $name ){
    $this->name = $name;
  }
  
  static function recruit ( $name  ){
    $num = rand( 1, count( self::$types ) ) - 1;
	$class = self::$types[$num];
    return new $class( $name );
  }
  
  abstract function work(); 
}

class Builder extends Employee {
  function work(){
    echo $this->name," строитель";
  }
}
class Manager extends Employee {
  function work(){
    echo $this->name," менеджер";
  }
}
class Chief extends Employee {
  function work(){
    echo $this->name," руководитель";
  }
}

class NastyBoss {
  private $employees = array();
  
  function addEmployee( Employee $employee ){
    $this->employees[] = $employee;
  }
  
  function projectFails() {
    if ( count( $this->employees ) > 0 ){
	  $emp = array_pop( $this->employees );
	  $emp->work();
	}
  }
}

$boss = new NastyBoss;
$boss->addEmployee( Employee::recruit( "Василий" ) );
$boss->addEmployee( Employee::recruit( "Петр" ) );
$boss->addEmployee( Employee::recruit( "Федор" ) );
$boss->projectFails();
$boss->projectFails();
$boss->projectFails();








?>