<?php

/*Decorator помогает решить проблему, которая встречается при необходимости лишнего наследования. Нам нужно создать игровое поле Равнина, от него наследуются АлмазнаяРавнина и ЗагрязненнаяРавнина, но сделать одновременно АлмазнуюЗагрязненнуюРавнину сделать сложно обычным наследованием

В шаблоне строятся конвейеры, которые удобны для создания фильтров, буферизации, сжатия.

Удобно использовать для конвейеризации веб-запроса
*/
abstract class Tile {
  abstract function getWealthFactor();
}

class Plains extends Tile {
  private $wealthfactor = 2;
  
  function getWealthFactor(){
    return $this->wealthfactor;
  }
}

abstract class TileDecorator extends Tile {
  protected $tile;
  
  function __construct ( Tile $tile ) {
    $this->tile = $tile;
  }
}
class DiamondDecorator extends TileDecorator {
 function getWealthFactor(){
    return $this->tile->getWealthFactor()+2;
 }
}
class PollutionDecorator extends TileDecorator {
 function getWealthFactor(){
    return $this->tile->getWealthFactor()-4;
 }
}

$tile = new Plains();
echo "Равнина: ",$tile->getWealthFactor(),"<br>";

$tile = new DiamondDecorator( new Plains() );
echo "АлмазнаяРавнина: ",$tile->getWealthFactor(),"<br>";

$tile = new PollutionDecorator( new DiamondDecorator( new Plains() ) );
echo "ЗагрязненнаяАлмазнаяРавнина: ",$tile->getWealthFactor(),"<br>";








?>