<?php

class Atmosphere {}
class PlanetAtmosphere {}
class MeteoriteAtmosphere {}

class Resource {}
class PlanetResource {}
class MeteoriteResource {}

class BodyspaceFactory {
 private $atmosphere;
 private $resource;
 
 function __construct(Atmosphere $atmo, Resource $res){
   $this->atmosphere = $atmo;
   $this->resource   = $res;
 }
 
 function getAtmosphere(){
   return clone $this->atmosphere;
 }
 
 function getResource(){
   return clone $this->resource;
 }
}


$factory = new BodyspaceFactory(
  new Atmosphere(),
  new Resource()
);
print_r($factory->getAtmosphere());
print_r($factory->getResource());